@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinitionArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.MongoRoleDefinitionType
import com.pulumi.azurenative.documentdb.kotlin.inputs.PrivilegeArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.PrivilegeArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.RoleArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.RoleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB Mongo Role Definition.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-03-01-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBMongoDBRoleDefinitionCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongoDBResourceMongoRoleDefinition = new AzureNative.DocumentDB.MongoDBResourceMongoRoleDefinition("mongoDBResourceMongoRoleDefinition", new()
 *     {
 *         AccountName = "myAccountName",
 *         DatabaseName = "sales",
 *         MongoRoleDefinitionId = "myMongoRoleDefinitionId",
 *         Privileges = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.PrivilegeArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "insert",
 *                     "find",
 *                 },
 *                 Resource = new AzureNative.DocumentDB.Inputs.PrivilegeResourceArgs
 *                 {
 *                     Collection = "sales",
 *                     Db = "sales",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         RoleName = "myRoleName",
 *         Roles = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.RoleArgs
 *             {
 *                 Db = "sales",
 *                 Role = "myInheritedRole",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewMongoDBResourceMongoRoleDefinition(ctx, "mongoDBResourceMongoRoleDefinition", &documentdb.MongoDBResourceMongoRoleDefinitionArgs{
 * 			AccountName:           pulumi.String("myAccountName"),
 * 			DatabaseName:          pulumi.String("sales"),
 * 			MongoRoleDefinitionId: pulumi.String("myMongoRoleDefinitionId"),
 * 			Privileges: []documentdb.PrivilegeArgs{
 * 				{
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("insert"),
 * 						pulumi.String("find"),
 * 					},
 * 					Resource: {
 * 						Collection: pulumi.String("sales"),
 * 						Db:         pulumi.String("sales"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			RoleName:          pulumi.String("myRoleName"),
 * 			Roles: []documentdb.RoleArgs{
 * 				{
 * 					Db:   pulumi.String("sales"),
 * 					Role: pulumi.String("myInheritedRole"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinition;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongoDBResourceMongoRoleDefinition = new MongoDBResourceMongoRoleDefinition("mongoDBResourceMongoRoleDefinition", MongoDBResourceMongoRoleDefinitionArgs.builder()
 *             .accountName("myAccountName")
 *             .databaseName("sales")
 *             .mongoRoleDefinitionId("myMongoRoleDefinitionId")
 *             .privileges(Map.ofEntries(
 *                 Map.entry("actions",
 *                     "insert",
 *                     "find"),
 *                 Map.entry("resource", Map.ofEntries(
 *                     Map.entry("collection", "sales"),
 *                     Map.entry("db", "sales")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroupName")
 *             .roleName("myRoleName")
 *             .roles(Map.ofEntries(
 *                 Map.entry("db", "sales"),
 *                 Map.entry("role", "myInheritedRole")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:MongoDBResourceMongoRoleDefinition myMongoDbRoleDefinitionId /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbRoleDefinitions/{mongoRoleDefinitionId}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property databaseName The database name for which access is being granted for this Role Definition.
 * @property mongoRoleDefinitionId The ID for the Role Definition {dbName.roleName}.
 * @property privileges A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property roleName A user-friendly name for the Role Definition. Must be unique for the database account.
 * @property roles The set of roles inherited by this Role Definition.
 * @property type Indicates whether the Role Definition was built-in or user created.
 */
public data class MongoDBResourceMongoRoleDefinitionArgs(
    public val accountName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val mongoRoleDefinitionId: Output<String>? = null,
    public val privileges: Output<List<PrivilegeArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roleName: Output<String>? = null,
    public val roles: Output<List<RoleArgs>>? = null,
    public val type: Output<MongoRoleDefinitionType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinitionArgs =
        com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinitionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .mongoRoleDefinitionId(mongoRoleDefinitionId?.applyValue({ args0 -> args0 }))
            .privileges(
                privileges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MongoDBResourceMongoRoleDefinitionArgs].
 */
@PulumiTagMarker
public class MongoDBResourceMongoRoleDefinitionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var mongoRoleDefinitionId: Output<String>? = null

    private var privileges: Output<List<PrivilegeArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var roleName: Output<String>? = null

    private var roles: Output<List<RoleArgs>>? = null

    private var type: Output<MongoRoleDefinitionType>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("njgvhooxqwsnjvvl")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The database name for which access is being granted for this Role Definition.
     */
    @JvmName("omuegqfououhxesc")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The ID for the Role Definition {dbName.roleName}.
     */
    @JvmName("cknfjdjimpsjgpii")
    public suspend fun mongoRoleDefinitionId(`value`: Output<String>) {
        this.mongoRoleDefinitionId = value
    }

    /**
     * @param value A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege.
     */
    @JvmName("qnekjxetpettsacm")
    public suspend fun privileges(`value`: Output<List<PrivilegeArgs>>) {
        this.privileges = value
    }

    @JvmName("lwfmjubgfsroioej")
    public suspend fun privileges(vararg values: Output<PrivilegeArgs>) {
        this.privileges = Output.all(values.asList())
    }

    /**
     * @param values A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege.
     */
    @JvmName("yimgnmtiscechqcq")
    public suspend fun privileges(values: List<Output<PrivilegeArgs>>) {
        this.privileges = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bhuokgxmvipqosvi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A user-friendly name for the Role Definition. Must be unique for the database account.
     */
    @JvmName("ejwewcinkdljbxet")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The set of roles inherited by this Role Definition.
     */
    @JvmName("lqghfmiwhnyavtmk")
    public suspend fun roles(`value`: Output<List<RoleArgs>>) {
        this.roles = value
    }

    @JvmName("puwgpskujgirleys")
    public suspend fun roles(vararg values: Output<RoleArgs>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values The set of roles inherited by this Role Definition.
     */
    @JvmName("ajceidaiqmbrdard")
    public suspend fun roles(values: List<Output<RoleArgs>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value Indicates whether the Role Definition was built-in or user created.
     */
    @JvmName("emwpyytlmhgyjhll")
    public suspend fun type(`value`: Output<MongoRoleDefinitionType>) {
        this.type = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("edfylpigyiktsqel")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The database name for which access is being granted for this Role Definition.
     */
    @JvmName("yuepkletefsxuttp")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The ID for the Role Definition {dbName.roleName}.
     */
    @JvmName("uoqgikxkyogwcvne")
    public suspend fun mongoRoleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mongoRoleDefinitionId = mapped
    }

    /**
     * @param value A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege.
     */
    @JvmName("aufrefyrsxbmhfnx")
    public suspend fun privileges(`value`: List<PrivilegeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privileges = mapped
    }

    /**
     * @param argument A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege.
     */
    @JvmName("athweqoaxqxfvfck")
    public suspend fun privileges(argument: List<suspend PrivilegeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PrivilegeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.privileges = mapped
    }

    /**
     * @param argument A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege.
     */
    @JvmName("wupxskqwjqresmox")
    public suspend fun privileges(vararg argument: suspend PrivilegeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PrivilegeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.privileges = mapped
    }

    /**
     * @param argument A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege.
     */
    @JvmName("kailvarbdbjrycsj")
    public suspend fun privileges(argument: suspend PrivilegeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrivilegeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.privileges = mapped
    }

    /**
     * @param values A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege.
     */
    @JvmName("yqawqbolrjqyjmee")
    public suspend fun privileges(vararg values: PrivilegeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privileges = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rjdcnlobcdoyrwje")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A user-friendly name for the Role Definition. Must be unique for the database account.
     */
    @JvmName("ugegvisxtrhtxqjn")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value The set of roles inherited by this Role Definition.
     */
    @JvmName("nqtkxncdpnijgfph")
    public suspend fun roles(`value`: List<RoleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param argument The set of roles inherited by this Role Definition.
     */
    @JvmName("kwntoehbqidxdjih")
    public suspend fun roles(argument: List<suspend RoleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RoleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument The set of roles inherited by this Role Definition.
     */
    @JvmName("cxeesirjsieuqqxy")
    public suspend fun roles(vararg argument: suspend RoleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RoleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument The set of roles inherited by this Role Definition.
     */
    @JvmName("ebesybckgcdjhwnv")
    public suspend fun roles(argument: suspend RoleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RoleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param values The set of roles inherited by this Role Definition.
     */
    @JvmName("wcjkvdtwbgklsgkj")
    public suspend fun roles(vararg values: RoleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value Indicates whether the Role Definition was built-in or user created.
     */
    @JvmName("pxyxeuemqybjlhnq")
    public suspend fun type(`value`: MongoRoleDefinitionType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MongoDBResourceMongoRoleDefinitionArgs =
        MongoDBResourceMongoRoleDefinitionArgs(
            accountName = accountName,
            databaseName = databaseName,
            mongoRoleDefinitionId = mongoRoleDefinitionId,
            privileges = privileges,
            resourceGroupName = resourceGroupName,
            roleName = roleName,
            roles = roles,
            type = type,
        )
}
