@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinitionArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.RoleArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.RoleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB User Definition
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBMongoDBUserDefinitionCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongoDBResourceMongoUserDefinition = new AzureNative.DocumentDB.MongoDBResourceMongoUserDefinition("mongoDBResourceMongoUserDefinition", new()
 *     {
 *         AccountName = "myAccountName",
 *         CustomData = "My custom data",
 *         DatabaseName = "sales",
 *         Mechanisms = "SCRAM-SHA-256",
 *         MongoUserDefinitionId = "myMongoUserDefinitionId",
 *         Password = "myPassword",
 *         ResourceGroupName = "myResourceGroupName",
 *         Roles = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.RoleArgs
 *             {
 *                 Db = "sales",
 *                 Role = "myReadRole",
 *             },
 *         },
 *         UserName = "myUserName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewMongoDBResourceMongoUserDefinition(ctx, "mongoDBResourceMongoUserDefinition", &documentdb.MongoDBResourceMongoUserDefinitionArgs{
 * 			AccountName:           pulumi.String("myAccountName"),
 * 			CustomData:            pulumi.String("My custom data"),
 * 			DatabaseName:          pulumi.String("sales"),
 * 			Mechanisms:            pulumi.String("SCRAM-SHA-256"),
 * 			MongoUserDefinitionId: pulumi.String("myMongoUserDefinitionId"),
 * 			Password:              pulumi.String("myPassword"),
 * 			ResourceGroupName:     pulumi.String("myResourceGroupName"),
 * 			Roles: []documentdb.RoleArgs{
 * 				{
 * 					Db:   pulumi.String("sales"),
 * 					Role: pulumi.String("myReadRole"),
 * 				},
 * 			},
 * 			UserName: pulumi.String("myUserName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinition;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongoDBResourceMongoUserDefinition = new MongoDBResourceMongoUserDefinition("mongoDBResourceMongoUserDefinition", MongoDBResourceMongoUserDefinitionArgs.builder()
 *             .accountName("myAccountName")
 *             .customData("My custom data")
 *             .databaseName("sales")
 *             .mechanisms("SCRAM-SHA-256")
 *             .mongoUserDefinitionId("myMongoUserDefinitionId")
 *             .password("myPassword")
 *             .resourceGroupName("myResourceGroupName")
 *             .roles(Map.ofEntries(
 *                 Map.entry("db", "sales"),
 *                 Map.entry("role", "myReadRole")
 *             ))
 *             .userName("myUserName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:MongoDBResourceMongoUserDefinition myUserName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbUserDefinitions/{mongoUserDefinitionId}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property customData A custom definition for the USer Definition.
 * @property databaseName The database name for which access is being granted for this User Definition.
 * @property mechanisms The Mongo Auth mechanism. For now, we only support auth mechanism SCRAM-SHA-256.
 * @property mongoUserDefinitionId The ID for the User Definition {dbName.userName}.
 * @property password The password for User Definition. Response does not contain user password.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property roles The set of roles inherited by the User Definition.
 * @property userName The user name for User Definition.
 */
public data class MongoDBResourceMongoUserDefinitionArgs(
    public val accountName: Output<String>? = null,
    public val customData: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val mechanisms: Output<String>? = null,
    public val mongoUserDefinitionId: Output<String>? = null,
    public val password: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val roles: Output<List<RoleArgs>>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinitionArgs =
        com.pulumi.azurenative.documentdb.MongoDBResourceMongoUserDefinitionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .customData(customData?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .mechanisms(mechanisms?.applyValue({ args0 -> args0 }))
            .mongoUserDefinitionId(mongoUserDefinitionId?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoDBResourceMongoUserDefinitionArgs].
 */
@PulumiTagMarker
public class MongoDBResourceMongoUserDefinitionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var customData: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var mechanisms: Output<String>? = null

    private var mongoUserDefinitionId: Output<String>? = null

    private var password: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var roles: Output<List<RoleArgs>>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("xhtobfreoqbqrkin")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value A custom definition for the USer Definition.
     */
    @JvmName("yogwqhqllqpmyqxl")
    public suspend fun customData(`value`: Output<String>) {
        this.customData = value
    }

    /**
     * @param value The database name for which access is being granted for this User Definition.
     */
    @JvmName("jsfugaivjvkntrcp")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The Mongo Auth mechanism. For now, we only support auth mechanism SCRAM-SHA-256.
     */
    @JvmName("dvedtesxrjvtrfgw")
    public suspend fun mechanisms(`value`: Output<String>) {
        this.mechanisms = value
    }

    /**
     * @param value The ID for the User Definition {dbName.userName}.
     */
    @JvmName("butomsilrehkfgsu")
    public suspend fun mongoUserDefinitionId(`value`: Output<String>) {
        this.mongoUserDefinitionId = value
    }

    /**
     * @param value The password for User Definition. Response does not contain user password.
     */
    @JvmName("injhrddiiagnykna")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hsskyjrrrsrqudar")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The set of roles inherited by the User Definition.
     */
    @JvmName("lhbwatoacshkycjl")
    public suspend fun roles(`value`: Output<List<RoleArgs>>) {
        this.roles = value
    }

    @JvmName("thkofvilsbmkoouk")
    public suspend fun roles(vararg values: Output<RoleArgs>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values The set of roles inherited by the User Definition.
     */
    @JvmName("kjrfyxiavbkbtwtv")
    public suspend fun roles(values: List<Output<RoleArgs>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value The user name for User Definition.
     */
    @JvmName("apvvtkssrxhcqqmj")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("mduqdfolfqlvmyeu")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value A custom definition for the USer Definition.
     */
    @JvmName("lscmgbafebiwjmkd")
    public suspend fun customData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customData = mapped
    }

    /**
     * @param value The database name for which access is being granted for this User Definition.
     */
    @JvmName("ebuhcbweiallwvwa")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The Mongo Auth mechanism. For now, we only support auth mechanism SCRAM-SHA-256.
     */
    @JvmName("gblgrnkhsubdpron")
    public suspend fun mechanisms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mechanisms = mapped
    }

    /**
     * @param value The ID for the User Definition {dbName.userName}.
     */
    @JvmName("nuoxqsoingfpvopn")
    public suspend fun mongoUserDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mongoUserDefinitionId = mapped
    }

    /**
     * @param value The password for User Definition. Response does not contain user password.
     */
    @JvmName("omgaamhblkonfsqg")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("weieyiprgtdkstov")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The set of roles inherited by the User Definition.
     */
    @JvmName("osidgkixylhwycks")
    public suspend fun roles(`value`: List<RoleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param argument The set of roles inherited by the User Definition.
     */
    @JvmName("afqnrtxtkmnhimhr")
    public suspend fun roles(argument: List<suspend RoleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RoleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument The set of roles inherited by the User Definition.
     */
    @JvmName("dymtqyoxoeseprcb")
    public suspend fun roles(vararg argument: suspend RoleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RoleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument The set of roles inherited by the User Definition.
     */
    @JvmName("jgonxlxfqnxlmnhc")
    public suspend fun roles(argument: suspend RoleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RoleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param values The set of roles inherited by the User Definition.
     */
    @JvmName("ndaxtmgtuwcbvpbw")
    public suspend fun roles(vararg values: RoleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value The user name for User Definition.
     */
    @JvmName("omuthfmokggmnvje")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): MongoDBResourceMongoUserDefinitionArgs =
        MongoDBResourceMongoUserDefinitionArgs(
            accountName = accountName,
            customData = customData,
            databaseName = databaseName,
            mechanisms = mechanisms,
            mongoUserDefinitionId = mongoUserDefinitionId,
            password = password,
            resourceGroupName = resourceGroupName,
            roles = roles,
            userName = userName,
        )
}
