@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.SqlResourceSqlContainerArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.SqlContainerResourceArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.SqlContainerResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB container.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBSqlContainerCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlResourceSqlContainer = new AzureNative.DocumentDB.SqlResourceSqlContainer("sqlResourceSqlContainer", new()
 *     {
 *         AccountName = "ddb1",
 *         ContainerName = "containerName",
 *         DatabaseName = "databaseName",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.SqlContainerResourceArgs
 *         {
 *             ClientEncryptionPolicy = new AzureNative.DocumentDB.Inputs.ClientEncryptionPolicyArgs
 *             {
 *                 IncludedPaths = new[]
 *                 {
 *                     new AzureNative.DocumentDB.Inputs.ClientEncryptionIncludedPathArgs
 *                     {
 *                         ClientEncryptionKeyId = "keyId",
 *                         EncryptionAlgorithm = "AEAD_AES_256_CBC_HMAC_SHA256",
 *                         EncryptionType = "Deterministic",
 *                         Path = "/path",
 *                     },
 *                 },
 *                 PolicyFormatVersion = 2,
 *             },
 *             ConflictResolutionPolicy = new AzureNative.DocumentDB.Inputs.ConflictResolutionPolicyArgs
 *             {
 *                 ConflictResolutionPath = "/path",
 *                 Mode = "LastWriterWins",
 *             },
 *             DefaultTtl = 100,
 *             Id = "containerName",
 *             IndexingPolicy = new AzureNative.DocumentDB.Inputs.IndexingPolicyArgs
 *             {
 *                 Automatic = true,
 *                 ExcludedPaths = new[] {},
 *                 IncludedPaths = new[]
 *                 {
 *                     new AzureNative.DocumentDB.Inputs.IncludedPathArgs
 *                     {
 *                         Indexes = new[]
 *                         {
 *                             new AzureNative.DocumentDB.Inputs.IndexesArgs
 *                             {
 *                                 DataType = "String",
 *                                 Kind = "Range",
 *                                 Precision = -1,
 *                             },
 *                             new AzureNative.DocumentDB.Inputs.IndexesArgs
 *                             {
 *                                 DataType = "Number",
 *                                 Kind = "Range",
 *                                 Precision = -1,
 *                             },
 *                         },
 *                         Path = "/*",
 *                     },
 *                 },
 *                 IndexingMode = "consistent",
 *             },
 *             PartitionKey = new AzureNative.DocumentDB.Inputs.ContainerPartitionKeyArgs
 *             {
 *                 Kind = "Hash",
 *                 Paths = new[]
 *                 {
 *                     "/AccountNumber",
 *                 },
 *             },
 *             UniqueKeyPolicy = new AzureNative.DocumentDB.Inputs.UniqueKeyPolicyArgs
 *             {
 *                 UniqueKeys = new[]
 *                 {
 *                     new AzureNative.DocumentDB.Inputs.UniqueKeyArgs
 *                     {
 *                         Paths = new[]
 *                         {
 *                             "/testPath",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := documentdb.NewSqlResourceSqlContainer(ctx, "sqlResourceSqlContainer", &documentdb.SqlResourceSqlContainerArgs{
 * AccountName: pulumi.String("ddb1"),
 * ContainerName: pulumi.String("containerName"),
 * DatabaseName: pulumi.String("databaseName"),
 * Location: pulumi.String("West US"),
 * Options: nil,
 * Resource: documentdb.SqlContainerGetPropertiesResponseResource{
 * ClientEncryptionPolicy: interface{}{
 * IncludedPaths: documentdb.ClientEncryptionIncludedPathArray{
 * &documentdb.ClientEncryptionIncludedPathArgs{
 * ClientEncryptionKeyId: pulumi.String("keyId"),
 * EncryptionAlgorithm: pulumi.String("AEAD_AES_256_CBC_HMAC_SHA256"),
 * EncryptionType: pulumi.String("Deterministic"),
 * Path: pulumi.String("/path"),
 * },
 * },
 * PolicyFormatVersion: pulumi.Int(2),
 * },
 * ConflictResolutionPolicy: &documentdb.ConflictResolutionPolicyArgs{
 * ConflictResolutionPath: pulumi.String("/path"),
 * Mode: pulumi.String("LastWriterWins"),
 * },
 * DefaultTtl: pulumi.Int(100),
 * Id: pulumi.String("containerName"),
 * IndexingPolicy: interface{}{
 * Automatic: pulumi.Bool(true),
 * ExcludedPaths: documentdb.ExcludedPathArray{
 * },
 * IncludedPaths: documentdb.IncludedPathArray{
 * interface{}{
 * Indexes: documentdb.IndexesArray{
 * &documentdb.IndexesArgs{
 * DataType: pulumi.String("String"),
 * Kind: pulumi.String("Range"),
 * Precision: -1,
 * },
 * &documentdb.IndexesArgs{
 * DataType: pulumi.String("Number"),
 * Kind: pulumi.String("Range"),
 * Precision: -1,
 * },
 * },
 * Path: pulumi.String("/*"),
 * },
 * },
 * IndexingMode: pulumi.String("consistent"),
 * },
 * PartitionKey: &documentdb.ContainerPartitionKeyArgs{
 * Kind: pulumi.String("Hash"),
 * Paths: pulumi.StringArray{
 * pulumi.String("/AccountNumber"),
 * },
 * },
 * UniqueKeyPolicy: interface{}{
 * UniqueKeys: documentdb.UniqueKeyArray{
 * &documentdb.UniqueKeyArgs{
 * Paths: pulumi.StringArray{
 * pulumi.String("/testPath"),
 * },
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlContainer;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlResourceSqlContainer = new SqlResourceSqlContainer("sqlResourceSqlContainer", SqlResourceSqlContainerArgs.builder()
 *             .accountName("ddb1")
 *             .containerName("containerName")
 *             .databaseName("databaseName")
 *             .location("West US")
 *             .options()
 *             .resource(Map.ofEntries(
 *                 Map.entry("clientEncryptionPolicy", Map.ofEntries(
 *                     Map.entry("includedPaths", Map.ofEntries(
 *                         Map.entry("clientEncryptionKeyId", "keyId"),
 *                         Map.entry("encryptionAlgorithm", "AEAD_AES_256_CBC_HMAC_SHA256"),
 *                         Map.entry("encryptionType", "Deterministic"),
 *                         Map.entry("path", "/path")
 *                     )),
 *                     Map.entry("policyFormatVersion", 2)
 *                 )),
 *                 Map.entry("conflictResolutionPolicy", Map.ofEntries(
 *                     Map.entry("conflictResolutionPath", "/path"),
 *                     Map.entry("mode", "LastWriterWins")
 *                 )),
 *                 Map.entry("defaultTtl", 100),
 *                 Map.entry("id", "containerName"),
 *                 Map.entry("indexingPolicy", Map.ofEntries(
 *                     Map.entry("automatic", true),
 *                     Map.entry("excludedPaths", ),
 *                     Map.entry("includedPaths", Map.ofEntries(
 *                         Map.entry("indexes",
 *                             Map.ofEntries(
 *                                 Map.entry("dataType", "String"),
 *                                 Map.entry("kind", "Range"),
 *                                 Map.entry("precision", "TODO: GenUnaryOpExpression")
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("dataType", "Number"),
 *                                 Map.entry("kind", "Range"),
 *                                 Map.entry("precision", "TODO: GenUnaryOpExpression")
 *                             )),
 *                         Map.entry("path", "/*")
 *                     )),
 *                     Map.entry("indexingMode", "consistent")
 *                 )),
 *                 Map.entry("partitionKey", Map.ofEntries(
 *                     Map.entry("kind", "Hash"),
 *                     Map.entry("paths", "/AccountNumber")
 *                 )),
 *                 Map.entry("uniqueKeyPolicy", Map.of("uniqueKeys", Map.of("paths", "/testPath")))
 *             ))
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:SqlResourceSqlContainer containerName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property containerName Cosmos DB container name.
 * @property databaseName Cosmos DB database name.
 * @property location The location of the resource group to which the resource belongs.
 * @property options A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
 * @property resource The standard JSON format of a container
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 * */*/*/
 */
public data class SqlResourceSqlContainerArgs(
    public val accountName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val options: Output<CreateUpdateOptionsArgs>? = null,
    public val resource: Output<SqlContainerResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.SqlResourceSqlContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.SqlResourceSqlContainerArgs =
        com.pulumi.azurenative.documentdb.SqlResourceSqlContainerArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SqlResourceSqlContainerArgs].
 */
@PulumiTagMarker
public class SqlResourceSqlContainerArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var location: Output<String>? = null

    private var options: Output<CreateUpdateOptionsArgs>? = null

    private var resource: Output<SqlContainerResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("brvbwcrvcikjbvfi")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("luyvyitbrbsrrsjo")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("ditcckntrjovkiyi")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("fponemwujegdovln")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("jesjhmkfpvyswgey")
    public suspend fun options(`value`: Output<CreateUpdateOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value The standard JSON format of a container
     */
    @JvmName("plwnivngwfgwpebn")
    public suspend fun resource(`value`: Output<SqlContainerResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cqdpfsohcrtpnxsf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("vtvfnqpptctljjht")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("bntyjimkiwxruwby")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("myqiuufkpdqehuup")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("rwtmbpkbesoekudu")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("jcfxttthteoxjllb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("wetkkcodkuovjnlp")
    public suspend fun options(`value`: CreateUpdateOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("lhxhapedrilkurtn")
    public suspend fun options(argument: suspend CreateUpdateOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = CreateUpdateOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value The standard JSON format of a container
     */
    @JvmName("mmsnnojqsydtosdv")
    public suspend fun resource(`value`: SqlContainerResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument The standard JSON format of a container
     */
    @JvmName("kjtjciyykfgkrqvy")
    public suspend fun resource(argument: suspend SqlContainerResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SqlContainerResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("swmawouugmoooikp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("gghwnwsfiuxyxbxq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("kydajvkivobgefas")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SqlResourceSqlContainerArgs = SqlResourceSqlContainerArgs(
        accountName = accountName,
        containerName = containerName,
        databaseName = databaseName,
        location = location,
        options = options,
        resource = resource,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
