@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SqlResourceSqlRoleAssignment].
 */
@PulumiTagMarker
public class SqlResourceSqlRoleAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlResourceSqlRoleAssignmentArgs = SqlResourceSqlRoleAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlResourceSqlRoleAssignmentArgsBuilder.() -> Unit) {
        val builder = SqlResourceSqlRoleAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlResourceSqlRoleAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlResourceSqlRoleAssignment(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB Role Assignment
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2023-09-15, 2023-09-15-preview, 2023-11-15, 2023-11-15-preview, 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDBSqlRoleAssignmentCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlResourceSqlRoleAssignment = new AzureNative.DocumentDB.SqlResourceSqlRoleAssignment("sqlResourceSqlRoleAssignment", new()
 *     {
 *         AccountName = "myAccountName",
 *         PrincipalId = "myPrincipalId",
 *         ResourceGroupName = "myResourceGroupName",
 *         RoleAssignmentId = "myRoleAssignmentId",
 *         RoleDefinitionId = "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/sqlRoleDefinitions/myRoleDefinitionId",
 *         Scope = "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases/colls/redmond-purchases",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewSqlResourceSqlRoleAssignment(ctx, "sqlResourceSqlRoleAssignment", &documentdb.SqlResourceSqlRoleAssignmentArgs{
 * 			AccountName:       pulumi.String("myAccountName"),
 * 			PrincipalId:       pulumi.String("myPrincipalId"),
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			RoleAssignmentId:  pulumi.String("myRoleAssignmentId"),
 * 			RoleDefinitionId:  pulumi.String("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/sqlRoleDefinitions/myRoleDefinitionId"),
 * 			Scope:             pulumi.String("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases/colls/redmond-purchases"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignment;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlResourceSqlRoleAssignment = new SqlResourceSqlRoleAssignment("sqlResourceSqlRoleAssignment", SqlResourceSqlRoleAssignmentArgs.builder()
 *             .accountName("myAccountName")
 *             .principalId("myPrincipalId")
 *             .resourceGroupName("myResourceGroupName")
 *             .roleAssignmentId("myRoleAssignmentId")
 *             .roleDefinitionId("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/sqlRoleDefinitions/myRoleDefinitionId")
 *             .scope("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases/colls/redmond-purchases")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:SqlResourceSqlRoleAssignment myRoleAssignmentId /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleAssignments/{roleAssignmentId}
 * ```
 */
public class SqlResourceSqlRoleAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignment,
) : KotlinCustomResource(javaResource, SqlResourceSqlRoleAssignmentMapper) {
    /**
     * The name of the database account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant associated with the subscription.
     */
    public val principalId: Output<String>?
        get() = javaResource.principalId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique identifier for the associated Role Definition.
     */
    public val roleDefinitionId: Output<String>?
        get() = javaResource.roleDefinitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The data plane resource path for which access is being granted through this Role Assignment.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlResourceSqlRoleAssignmentMapper : ResourceMapper<SqlResourceSqlRoleAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignment::class == javaResource::class

    override fun map(javaResource: Resource): SqlResourceSqlRoleAssignment =
        SqlResourceSqlRoleAssignment(
            javaResource as
                com.pulumi.azurenative.documentdb.SqlResourceSqlRoleAssignment,
        )
}

/**
 * @see [SqlResourceSqlRoleAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlResourceSqlRoleAssignment].
 */
public suspend fun sqlResourceSqlRoleAssignment(
    name: String,
    block: suspend SqlResourceSqlRoleAssignmentResourceBuilder.() -> Unit,
):
    SqlResourceSqlRoleAssignment {
    val builder = SqlResourceSqlRoleAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlResourceSqlRoleAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlResourceSqlRoleAssignment(name: String): SqlResourceSqlRoleAssignment {
    val builder = SqlResourceSqlRoleAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
