@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ThroughputPoolAccount].
 */
@PulumiTagMarker
public class ThroughputPoolAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ThroughputPoolAccountArgs = ThroughputPoolAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ThroughputPoolAccountArgsBuilder.() -> Unit) {
        val builder = ThroughputPoolAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ThroughputPoolAccount {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.ThroughputPoolAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ThroughputPoolAccount(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB Throughputpool Account
 * Azure REST API version: 2023-11-15-preview.
 * Other available API versions: 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDB ThroughputPool Account Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var throughputPoolAccount = new AzureNative.DocumentDB.ThroughputPoolAccount("throughputPoolAccount", new()
 *     {
 *         AccountLocation = "West US",
 *         AccountResourceIdentifier = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/providers/Microsoft.DocumentDB/resourceGroup/rg1/databaseAccounts/db1/",
 *         ResourceGroupName = "rg1",
 *         ThroughputPoolAccountName = "db1",
 *         ThroughputPoolName = "tp1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewThroughputPoolAccount(ctx, "throughputPoolAccount", &documentdb.ThroughputPoolAccountArgs{
 * 			AccountLocation:           pulumi.String("West US"),
 * 			AccountResourceIdentifier: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/providers/Microsoft.DocumentDB/resourceGroup/rg1/databaseAccounts/db1/"),
 * 			ResourceGroupName:         pulumi.String("rg1"),
 * 			ThroughputPoolAccountName: pulumi.String("db1"),
 * 			ThroughputPoolName:        pulumi.String("tp1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.ThroughputPoolAccount;
 * import com.pulumi.azurenative.documentdb.ThroughputPoolAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var throughputPoolAccount = new ThroughputPoolAccount("throughputPoolAccount", ThroughputPoolAccountArgs.builder()
 *             .accountLocation("West US")
 *             .accountResourceIdentifier("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/providers/Microsoft.DocumentDB/resourceGroup/rg1/databaseAccounts/db1/")
 *             .resourceGroupName("rg1")
 *             .throughputPoolAccountName("db1")
 *             .throughputPoolName("tp1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:ThroughputPoolAccount myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts/{throughputPoolAccountName}
 * ```
 */
public class ThroughputPoolAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.ThroughputPoolAccount,
) : KotlinCustomResource(javaResource, ThroughputPoolAccountMapper) {
    /**
     * The instance id of global database account in the throughputPool.
     */
    public val accountInstanceId: Output<String>
        get() = javaResource.accountInstanceId().applyValue({ args0 -> args0 })

    /**
     * The location of  global database account in the throughputPool.
     */
    public val accountLocation: Output<String>?
        get() = javaResource.accountLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource identifier of global database account in the throughputPool.
     */
    public val accountResourceIdentifier: Output<String>?
        get() = javaResource.accountResourceIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A provisioning state of the ThroughputPool Account.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ThroughputPoolAccountMapper : ResourceMapper<ThroughputPoolAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.ThroughputPoolAccount::class == javaResource::class

    override fun map(javaResource: Resource): ThroughputPoolAccount =
        ThroughputPoolAccount(javaResource as com.pulumi.azurenative.documentdb.ThroughputPoolAccount)
}

/**
 * @see [ThroughputPoolAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ThroughputPoolAccount].
 */
public suspend fun throughputPoolAccount(
    name: String,
    block: suspend ThroughputPoolAccountResourceBuilder.() -> Unit,
): ThroughputPoolAccount {
    val builder = ThroughputPoolAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ThroughputPoolAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun throughputPoolAccount(name: String): ThroughputPoolAccount {
    val builder = ThroughputPoolAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
