@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.ThroughputPoolAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB Throughputpool Account
 * Azure REST API version: 2023-11-15-preview.
 * Other available API versions: 2024-02-15-preview.
 * ## Example Usage
 * ### CosmosDB ThroughputPool Account Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var throughputPoolAccount = new AzureNative.DocumentDB.ThroughputPoolAccount("throughputPoolAccount", new()
 *     {
 *         AccountLocation = "West US",
 *         AccountResourceIdentifier = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/providers/Microsoft.DocumentDB/resourceGroup/rg1/databaseAccounts/db1/",
 *         ResourceGroupName = "rg1",
 *         ThroughputPoolAccountName = "db1",
 *         ThroughputPoolName = "tp1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewThroughputPoolAccount(ctx, "throughputPoolAccount", &documentdb.ThroughputPoolAccountArgs{
 * 			AccountLocation:           pulumi.String("West US"),
 * 			AccountResourceIdentifier: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/providers/Microsoft.DocumentDB/resourceGroup/rg1/databaseAccounts/db1/"),
 * 			ResourceGroupName:         pulumi.String("rg1"),
 * 			ThroughputPoolAccountName: pulumi.String("db1"),
 * 			ThroughputPoolName:        pulumi.String("tp1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.ThroughputPoolAccount;
 * import com.pulumi.azurenative.documentdb.ThroughputPoolAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var throughputPoolAccount = new ThroughputPoolAccount("throughputPoolAccount", ThroughputPoolAccountArgs.builder()
 *             .accountLocation("West US")
 *             .accountResourceIdentifier("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/providers/Microsoft.DocumentDB/resourceGroup/rg1/databaseAccounts/db1/")
 *             .resourceGroupName("rg1")
 *             .throughputPoolAccountName("db1")
 *             .throughputPoolName("tp1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:ThroughputPoolAccount myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/throughputPools/{throughputPoolName}/throughputPoolAccounts/{throughputPoolAccountName}
 * ```
 * @property accountLocation The location of  global database account in the throughputPool.
 * @property accountResourceIdentifier The resource identifier of global database account in the throughputPool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property throughputPoolAccountName Cosmos DB global database account in a Throughput Pool
 * @property throughputPoolName Cosmos DB Throughput Pool name.
 */
public data class ThroughputPoolAccountArgs(
    public val accountLocation: Output<String>? = null,
    public val accountResourceIdentifier: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val throughputPoolAccountName: Output<String>? = null,
    public val throughputPoolName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.ThroughputPoolAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.ThroughputPoolAccountArgs =
        com.pulumi.azurenative.documentdb.ThroughputPoolAccountArgs.builder()
            .accountLocation(accountLocation?.applyValue({ args0 -> args0 }))
            .accountResourceIdentifier(accountResourceIdentifier?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .throughputPoolAccountName(throughputPoolAccountName?.applyValue({ args0 -> args0 }))
            .throughputPoolName(throughputPoolName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThroughputPoolAccountArgs].
 */
@PulumiTagMarker
public class ThroughputPoolAccountArgsBuilder internal constructor() {
    private var accountLocation: Output<String>? = null

    private var accountResourceIdentifier: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var throughputPoolAccountName: Output<String>? = null

    private var throughputPoolName: Output<String>? = null

    /**
     * @param value The location of  global database account in the throughputPool.
     */
    @JvmName("dcfcvetmegfaxtpj")
    public suspend fun accountLocation(`value`: Output<String>) {
        this.accountLocation = value
    }

    /**
     * @param value The resource identifier of global database account in the throughputPool.
     */
    @JvmName("rsbofbifqibglxrx")
    public suspend fun accountResourceIdentifier(`value`: Output<String>) {
        this.accountResourceIdentifier = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("askoufojbataijxu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Cosmos DB global database account in a Throughput Pool
     */
    @JvmName("fopagrinsayiahxq")
    public suspend fun throughputPoolAccountName(`value`: Output<String>) {
        this.throughputPoolAccountName = value
    }

    /**
     * @param value Cosmos DB Throughput Pool name.
     */
    @JvmName("yrtqipbfucifxmfm")
    public suspend fun throughputPoolName(`value`: Output<String>) {
        this.throughputPoolName = value
    }

    /**
     * @param value The location of  global database account in the throughputPool.
     */
    @JvmName("vmxuponwmjlyaspj")
    public suspend fun accountLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountLocation = mapped
    }

    /**
     * @param value The resource identifier of global database account in the throughputPool.
     */
    @JvmName("qgskjjetfvdrwfow")
    public suspend fun accountResourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountResourceIdentifier = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yseafnrrrnddxvfu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cosmos DB global database account in a Throughput Pool
     */
    @JvmName("khfgbnppxelifvqh")
    public suspend fun throughputPoolAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputPoolAccountName = mapped
    }

    /**
     * @param value Cosmos DB Throughput Pool name.
     */
    @JvmName("qdgtskvrjfoqknqe")
    public suspend fun throughputPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputPoolName = mapped
    }

    internal fun build(): ThroughputPoolAccountArgs = ThroughputPoolAccountArgs(
        accountLocation = accountLocation,
        accountResourceIdentifier = accountResourceIdentifier,
        resourceGroupName = resourceGroupName,
        throughputPoolAccountName = throughputPoolAccountName,
        throughputPoolName = throughputPoolName,
    )
}
