@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CassandraKeyspaceResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB Cassandra keyspace resource object
 * @property id Name of the Cosmos DB Cassandra keyspace
 */
public data class CassandraKeyspaceResourceArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CassandraKeyspaceResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CassandraKeyspaceResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.CassandraKeyspaceResourceArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CassandraKeyspaceResourceArgs].
 */
@PulumiTagMarker
public class CassandraKeyspaceResourceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Name of the Cosmos DB Cassandra keyspace
     */
    @JvmName("dwnjyfyiaiwuhmqa")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the Cosmos DB Cassandra keyspace
     */
    @JvmName("olgpkfvhuiyxfdro")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): CassandraKeyspaceResourceArgs = CassandraKeyspaceResourceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
