@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ClientEncryptionIncludedPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * .
 * @property clientEncryptionKeyId The identifier of the Client Encryption Key to be used to encrypt the path.
 * @property encryptionAlgorithm The encryption algorithm which will be used. Eg - AEAD_AES_256_CBC_HMAC_SHA256.
 * @property encryptionType The type of encryption to be performed. Eg - Deterministic, Randomized.
 * @property path Path that needs to be encrypted.
 */
public data class ClientEncryptionIncludedPathArgs(
    public val clientEncryptionKeyId: Output<String>,
    public val encryptionAlgorithm: Output<String>,
    public val encryptionType: Output<String>,
    public val path: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ClientEncryptionIncludedPathArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ClientEncryptionIncludedPathArgs =
        com.pulumi.azurenative.documentdb.inputs.ClientEncryptionIncludedPathArgs.builder()
            .clientEncryptionKeyId(clientEncryptionKeyId.applyValue({ args0 -> args0 }))
            .encryptionAlgorithm(encryptionAlgorithm.applyValue({ args0 -> args0 }))
            .encryptionType(encryptionType.applyValue({ args0 -> args0 }))
            .path(path.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientEncryptionIncludedPathArgs].
 */
@PulumiTagMarker
public class ClientEncryptionIncludedPathArgsBuilder internal constructor() {
    private var clientEncryptionKeyId: Output<String>? = null

    private var encryptionAlgorithm: Output<String>? = null

    private var encryptionType: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value The identifier of the Client Encryption Key to be used to encrypt the path.
     */
    @JvmName("fnnbrrxyhluypxwk")
    public suspend fun clientEncryptionKeyId(`value`: Output<String>) {
        this.clientEncryptionKeyId = value
    }

    /**
     * @param value The encryption algorithm which will be used. Eg - AEAD_AES_256_CBC_HMAC_SHA256.
     */
    @JvmName("ugaxfcbbdvmqyotk")
    public suspend fun encryptionAlgorithm(`value`: Output<String>) {
        this.encryptionAlgorithm = value
    }

    /**
     * @param value The type of encryption to be performed. Eg - Deterministic, Randomized.
     */
    @JvmName("olfeircrclegnamf")
    public suspend fun encryptionType(`value`: Output<String>) {
        this.encryptionType = value
    }

    /**
     * @param value Path that needs to be encrypted.
     */
    @JvmName("rlfekjfrfgmwpmhr")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The identifier of the Client Encryption Key to be used to encrypt the path.
     */
    @JvmName("idcmfbrmboaystcx")
    public suspend fun clientEncryptionKeyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientEncryptionKeyId = mapped
    }

    /**
     * @param value The encryption algorithm which will be used. Eg - AEAD_AES_256_CBC_HMAC_SHA256.
     */
    @JvmName("hsvllqtbnsfbetyl")
    public suspend fun encryptionAlgorithm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value The type of encryption to be performed. Eg - Deterministic, Randomized.
     */
    @JvmName("lwswpaqixcvbomwq")
    public suspend fun encryptionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value Path that needs to be encrypted.
     */
    @JvmName("vufajulaokygtgvl")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): ClientEncryptionIncludedPathArgs = ClientEncryptionIncludedPathArgs(
        clientEncryptionKeyId = clientEncryptionKeyId ?: throw
            PulumiNullFieldException("clientEncryptionKeyId"),
        encryptionAlgorithm = encryptionAlgorithm ?: throw PulumiNullFieldException("encryptionAlgorithm"),
        encryptionType = encryptionType ?: throw PulumiNullFieldException("encryptionType"),
        path = path ?: throw PulumiNullFieldException("path"),
    )
}
