@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ClientEncryptionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cosmos DB client encryption policy.
 * @property includedPaths Paths of the item that need encryption along with path-specific settings.
 * @property policyFormatVersion Version of the client encryption policy definition. Supported versions are 1 and 2. Version 2 supports id and partition key path encryption.
 */
public data class ClientEncryptionPolicyArgs(
    public val includedPaths: Output<List<ClientEncryptionIncludedPathArgs>>,
    public val policyFormatVersion: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ClientEncryptionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ClientEncryptionPolicyArgs =
        com.pulumi.azurenative.documentdb.inputs.ClientEncryptionPolicyArgs.builder()
            .includedPaths(
                includedPaths.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .policyFormatVersion(policyFormatVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientEncryptionPolicyArgs].
 */
@PulumiTagMarker
public class ClientEncryptionPolicyArgsBuilder internal constructor() {
    private var includedPaths: Output<List<ClientEncryptionIncludedPathArgs>>? = null

    private var policyFormatVersion: Output<Int>? = null

    /**
     * @param value Paths of the item that need encryption along with path-specific settings.
     */
    @JvmName("llfocnlwckuignth")
    public suspend fun includedPaths(`value`: Output<List<ClientEncryptionIncludedPathArgs>>) {
        this.includedPaths = value
    }

    @JvmName("umdcrsvhrvorukxi")
    public suspend fun includedPaths(vararg values: Output<ClientEncryptionIncludedPathArgs>) {
        this.includedPaths = Output.all(values.asList())
    }

    /**
     * @param values Paths of the item that need encryption along with path-specific settings.
     */
    @JvmName("qtuyrpaxmnvcksft")
    public suspend fun includedPaths(values: List<Output<ClientEncryptionIncludedPathArgs>>) {
        this.includedPaths = Output.all(values)
    }

    /**
     * @param value Version of the client encryption policy definition. Supported versions are 1 and 2. Version 2 supports id and partition key path encryption.
     */
    @JvmName("vskjcbuwveichnbt")
    public suspend fun policyFormatVersion(`value`: Output<Int>) {
        this.policyFormatVersion = value
    }

    /**
     * @param value Paths of the item that need encryption along with path-specific settings.
     */
    @JvmName("iiofnswibvkcosmo")
    public suspend fun includedPaths(`value`: List<ClientEncryptionIncludedPathArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedPaths = mapped
    }

    /**
     * @param argument Paths of the item that need encryption along with path-specific settings.
     */
    @JvmName("tdoyhburojnawxry")
    public suspend
    fun includedPaths(argument: List<suspend ClientEncryptionIncludedPathArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClientEncryptionIncludedPathArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.includedPaths = mapped
    }

    /**
     * @param argument Paths of the item that need encryption along with path-specific settings.
     */
    @JvmName("xybifygqkjcqmahc")
    public suspend fun includedPaths(
        vararg
        argument: suspend ClientEncryptionIncludedPathArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ClientEncryptionIncludedPathArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.includedPaths = mapped
    }

    /**
     * @param argument Paths of the item that need encryption along with path-specific settings.
     */
    @JvmName("jbthotsdxaafbrba")
    public suspend
    fun includedPaths(argument: suspend ClientEncryptionIncludedPathArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClientEncryptionIncludedPathArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.includedPaths = mapped
    }

    /**
     * @param values Paths of the item that need encryption along with path-specific settings.
     */
    @JvmName("dnquxbahqgdvypof")
    public suspend fun includedPaths(vararg values: ClientEncryptionIncludedPathArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedPaths = mapped
    }

    /**
     * @param value Version of the client encryption policy definition. Supported versions are 1 and 2. Version 2 supports id and partition key path encryption.
     */
    @JvmName("wdyoumnhaeiwgcng")
    public suspend fun policyFormatVersion(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyFormatVersion = mapped
    }

    internal fun build(): ClientEncryptionPolicyArgs = ClientEncryptionPolicyArgs(
        includedPaths = includedPaths ?: throw PulumiNullFieldException("includedPaths"),
        policyFormatVersion = policyFormatVersion ?: throw PulumiNullFieldException("policyFormatVersion"),
    )
}
