@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ConsistencyPolicyArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.DefaultConsistencyLevel
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The consistency policy for the Cosmos DB database account.
 * @property defaultConsistencyLevel The default consistency level and configuration settings of the Cosmos DB account.
 * @property maxIntervalInSeconds When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
 * @property maxStalenessPrefix When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
 */
public data class ConsistencyPolicyArgs(
    public val defaultConsistencyLevel: Output<DefaultConsistencyLevel>,
    public val maxIntervalInSeconds: Output<Int>? = null,
    public val maxStalenessPrefix: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ConsistencyPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ConsistencyPolicyArgs =
        com.pulumi.azurenative.documentdb.inputs.ConsistencyPolicyArgs.builder()
            .defaultConsistencyLevel(
                defaultConsistencyLevel.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .maxIntervalInSeconds(maxIntervalInSeconds?.applyValue({ args0 -> args0 }))
            .maxStalenessPrefix(maxStalenessPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConsistencyPolicyArgs].
 */
@PulumiTagMarker
public class ConsistencyPolicyArgsBuilder internal constructor() {
    private var defaultConsistencyLevel: Output<DefaultConsistencyLevel>? = null

    private var maxIntervalInSeconds: Output<Int>? = null

    private var maxStalenessPrefix: Output<Double>? = null

    /**
     * @param value The default consistency level and configuration settings of the Cosmos DB account.
     */
    @JvmName("xmdckjofcreprnms")
    public suspend fun defaultConsistencyLevel(`value`: Output<DefaultConsistencyLevel>) {
        this.defaultConsistencyLevel = value
    }

    /**
     * @param value When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
     */
    @JvmName("umrcdxlppffabbhj")
    public suspend fun maxIntervalInSeconds(`value`: Output<Int>) {
        this.maxIntervalInSeconds = value
    }

    /**
     * @param value When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
     */
    @JvmName("mwbnfibcioipcfss")
    public suspend fun maxStalenessPrefix(`value`: Output<Double>) {
        this.maxStalenessPrefix = value
    }

    /**
     * @param value The default consistency level and configuration settings of the Cosmos DB account.
     */
    @JvmName("eojvgadjsmtmwgjb")
    public suspend fun defaultConsistencyLevel(`value`: DefaultConsistencyLevel) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultConsistencyLevel = mapped
    }

    /**
     * @param value When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
     */
    @JvmName("mlorvbvblaovoxjg")
    public suspend fun maxIntervalInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxIntervalInSeconds = mapped
    }

    /**
     * @param value When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
     */
    @JvmName("rixpxgvwdwejhljj")
    public suspend fun maxStalenessPrefix(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxStalenessPrefix = mapped
    }

    internal fun build(): ConsistencyPolicyArgs = ConsistencyPolicyArgs(
        defaultConsistencyLevel = defaultConsistencyLevel ?: throw
            PulumiNullFieldException("defaultConsistencyLevel"),
        maxIntervalInSeconds = maxIntervalInSeconds,
        maxStalenessPrefix = maxStalenessPrefix,
    )
}
