@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ContainerPartitionKeyArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.PartitionKind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration of the partition key to be used for partitioning data into multiple partitions
 * @property kind Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create
 * @property paths List of paths using which data within the container can be partitioned
 * @property version Indicates the version of the partition key definition
 */
public data class ContainerPartitionKeyArgs(
    public val kind: Output<Either<String, PartitionKind>>? = null,
    public val paths: Output<List<String>>? = null,
    public val version: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ContainerPartitionKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ContainerPartitionKeyArgs =
        com.pulumi.azurenative.documentdb.inputs.ContainerPartitionKeyArgs.builder()
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .paths(paths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerPartitionKeyArgs].
 */
@PulumiTagMarker
public class ContainerPartitionKeyArgsBuilder internal constructor() {
    private var kind: Output<Either<String, PartitionKind>>? = null

    private var paths: Output<List<String>>? = null

    private var version: Output<Int>? = null

    /**
     * @param value Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create
     */
    @JvmName("nhkeiupesbrhgllm")
    public suspend fun kind(`value`: Output<Either<String, PartitionKind>>) {
        this.kind = value
    }

    /**
     * @param value List of paths using which data within the container can be partitioned
     */
    @JvmName("xfsnsrtgeqguqaue")
    public suspend fun paths(`value`: Output<List<String>>) {
        this.paths = value
    }

    @JvmName("lpamwkdpeliuppfy")
    public suspend fun paths(vararg values: Output<String>) {
        this.paths = Output.all(values.asList())
    }

    /**
     * @param values List of paths using which data within the container can be partitioned
     */
    @JvmName("wscfgyqsrtlxaiam")
    public suspend fun paths(values: List<Output<String>>) {
        this.paths = Output.all(values)
    }

    /**
     * @param value Indicates the version of the partition key definition
     */
    @JvmName("dxfvpsucrohqxxhe")
    public suspend fun version(`value`: Output<Int>) {
        this.version = value
    }

    /**
     * @param value Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create
     */
    @JvmName("toockavpwtrpogtg")
    public suspend fun kind(`value`: Either<String, PartitionKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create
     */
    @JvmName("bpqftcyotncvvoks")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PartitionKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create
     */
    @JvmName("vcsnewshilfrvrym")
    public fun kind(`value`: PartitionKind) {
        val toBeMapped = Either.ofRight<String, PartitionKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value List of paths using which data within the container can be partitioned
     */
    @JvmName("lfxkakcqrdftwjtb")
    public suspend fun paths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    /**
     * @param values List of paths using which data within the container can be partitioned
     */
    @JvmName("ymgmivmcqptadofu")
    public suspend fun paths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    /**
     * @param value Indicates the version of the partition key definition
     */
    @JvmName("kaojjtgxhlnyqxfg")
    public suspend fun version(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ContainerPartitionKeyArgs = ContainerPartitionKeyArgs(
        kind = kind,
        paths = paths,
        version = version,
    )
}
