@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ContinuousModeBackupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The object representing continuous mode backup policy.
 * @property continuousModeProperties Configuration values for continuous mode backup
 * @property migrationState The object representing the state of the migration between the backup policies.
 * @property type Describes the mode of backups.
 * Expected value is 'Continuous'.
 */
public data class ContinuousModeBackupPolicyArgs(
    public val continuousModeProperties: Output<ContinuousModePropertiesArgs>? = null,
    public val migrationState: Output<BackupPolicyMigrationStateArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ContinuousModeBackupPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ContinuousModeBackupPolicyArgs =
        com.pulumi.azurenative.documentdb.inputs.ContinuousModeBackupPolicyArgs.builder()
            .continuousModeProperties(
                continuousModeProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .migrationState(migrationState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContinuousModeBackupPolicyArgs].
 */
@PulumiTagMarker
public class ContinuousModeBackupPolicyArgsBuilder internal constructor() {
    private var continuousModeProperties: Output<ContinuousModePropertiesArgs>? = null

    private var migrationState: Output<BackupPolicyMigrationStateArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Configuration values for continuous mode backup
     */
    @JvmName("dufdyshaqqehwctk")
    public suspend fun continuousModeProperties(`value`: Output<ContinuousModePropertiesArgs>) {
        this.continuousModeProperties = value
    }

    /**
     * @param value The object representing the state of the migration between the backup policies.
     */
    @JvmName("tpupksuhycdhqlsk")
    public suspend fun migrationState(`value`: Output<BackupPolicyMigrationStateArgs>) {
        this.migrationState = value
    }

    /**
     * @param value Describes the mode of backups.
     * Expected value is 'Continuous'.
     */
    @JvmName("vedjypkuhhtsbnsa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Configuration values for continuous mode backup
     */
    @JvmName("pwkevpqtcstfcsrg")
    public suspend fun continuousModeProperties(`value`: ContinuousModePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.continuousModeProperties = mapped
    }

    /**
     * @param argument Configuration values for continuous mode backup
     */
    @JvmName("aahormsgatjmovde")
    public suspend
    fun continuousModeProperties(argument: suspend ContinuousModePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ContinuousModePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.continuousModeProperties = mapped
    }

    /**
     * @param value The object representing the state of the migration between the backup policies.
     */
    @JvmName("ohxlfsvnirhwshrp")
    public suspend fun migrationState(`value`: BackupPolicyMigrationStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationState = mapped
    }

    /**
     * @param argument The object representing the state of the migration between the backup policies.
     */
    @JvmName("xyhkdadddbaewteg")
    public suspend
    fun migrationState(argument: suspend BackupPolicyMigrationStateArgsBuilder.() -> Unit) {
        val toBeMapped = BackupPolicyMigrationStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.migrationState = mapped
    }

    /**
     * @param value Describes the mode of backups.
     * Expected value is 'Continuous'.
     */
    @JvmName("fjxfmudgtyugemik")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ContinuousModeBackupPolicyArgs = ContinuousModeBackupPolicyArgs(
        continuousModeProperties = continuousModeProperties,
        migrationState = migrationState,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
