@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CorsPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The CORS policy for the Cosmos DB database account.
 * @property allowedHeaders The request headers that the origin domain may specify on the CORS request.
 * @property allowedMethods The methods (HTTP request verbs) that the origin domain may use for a CORS request.
 * @property allowedOrigins The origin domains that are permitted to make a request against the service via CORS.
 * @property exposedHeaders The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
 * @property maxAgeInSeconds The maximum amount time that a browser should cache the preflight OPTIONS request.
 */
public data class CorsPolicyArgs(
    public val allowedHeaders: Output<String>? = null,
    public val allowedMethods: Output<String>? = null,
    public val allowedOrigins: Output<String>,
    public val exposedHeaders: Output<String>? = null,
    public val maxAgeInSeconds: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CorsPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CorsPolicyArgs =
        com.pulumi.azurenative.documentdb.inputs.CorsPolicyArgs.builder()
            .allowedHeaders(allowedHeaders?.applyValue({ args0 -> args0 }))
            .allowedMethods(allowedMethods?.applyValue({ args0 -> args0 }))
            .allowedOrigins(allowedOrigins.applyValue({ args0 -> args0 }))
            .exposedHeaders(exposedHeaders?.applyValue({ args0 -> args0 }))
            .maxAgeInSeconds(maxAgeInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CorsPolicyArgs].
 */
@PulumiTagMarker
public class CorsPolicyArgsBuilder internal constructor() {
    private var allowedHeaders: Output<String>? = null

    private var allowedMethods: Output<String>? = null

    private var allowedOrigins: Output<String>? = null

    private var exposedHeaders: Output<String>? = null

    private var maxAgeInSeconds: Output<Double>? = null

    /**
     * @param value The request headers that the origin domain may specify on the CORS request.
     */
    @JvmName("bdcalnfpxrtjysvw")
    public suspend fun allowedHeaders(`value`: Output<String>) {
        this.allowedHeaders = value
    }

    /**
     * @param value The methods (HTTP request verbs) that the origin domain may use for a CORS request.
     */
    @JvmName("xralcqhfkbtjlwnj")
    public suspend fun allowedMethods(`value`: Output<String>) {
        this.allowedMethods = value
    }

    /**
     * @param value The origin domains that are permitted to make a request against the service via CORS.
     */
    @JvmName("pwxggjtnwksjvhcp")
    public suspend fun allowedOrigins(`value`: Output<String>) {
        this.allowedOrigins = value
    }

    /**
     * @param value The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
     */
    @JvmName("hlcpqglhcnvkptie")
    public suspend fun exposedHeaders(`value`: Output<String>) {
        this.exposedHeaders = value
    }

    /**
     * @param value The maximum amount time that a browser should cache the preflight OPTIONS request.
     */
    @JvmName("fpfhimjfxltxagsw")
    public suspend fun maxAgeInSeconds(`value`: Output<Double>) {
        this.maxAgeInSeconds = value
    }

    /**
     * @param value The request headers that the origin domain may specify on the CORS request.
     */
    @JvmName("grdteibwsjnixbjv")
    public suspend fun allowedHeaders(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param value The methods (HTTP request verbs) that the origin domain may use for a CORS request.
     */
    @JvmName("gifiasklnksseuol")
    public suspend fun allowedMethods(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value The origin domains that are permitted to make a request against the service via CORS.
     */
    @JvmName("vgjicsyibibjiugb")
    public suspend fun allowedOrigins(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param value The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
     */
    @JvmName("oalyokwarbvywwdi")
    public suspend fun exposedHeaders(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposedHeaders = mapped
    }

    /**
     * @param value The maximum amount time that a browser should cache the preflight OPTIONS request.
     */
    @JvmName("khgrmxkdmymnjwjs")
    public suspend fun maxAgeInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAgeInSeconds = mapped
    }

    internal fun build(): CorsPolicyArgs = CorsPolicyArgs(
        allowedHeaders = allowedHeaders,
        allowedMethods = allowedMethods,
        allowedOrigins = allowedOrigins ?: throw PulumiNullFieldException("allowedOrigins"),
        exposedHeaders = exposedHeaders,
        maxAgeInSeconds = maxAgeInSeconds,
    )
}
