@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.DataCenterResourcePropertiesArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.ManagedCassandraProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of a managed Cassandra data center.
 * @property authenticationMethodLdapProperties Ldap authentication method properties. This feature is in preview.
 * @property availabilityZone If the data center has Availability Zone support, apply it to the Virtual Machine ScaleSet that host the cassandra data center virtual machines.
 * @property backupStorageCustomerKeyUri Indicates the Key Uri of the customer key to use for encryption of the backup storage account.
 * @property base64EncodedCassandraYamlFragment A fragment of a cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this data center. The fragment should be Base64 encoded, and only a subset of keys are allowed.
 * @property dataCenterLocation The region this data center should be created in.
 * @property deallocated Whether the data center has been deallocated.
 * @property delegatedSubnetId Resource id of a subnet the nodes in this data center should have their network interfaces connected to. The subnet must be in the same region specified in 'dataCenterLocation' and must be able to route to the subnet specified in the cluster's 'delegatedManagementSubnetId' property. This resource id will be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'.
 * @property diskCapacity Number of disks attached to each node. Default is 4.
 * @property diskSku Disk SKU used for data centers. Default value is P30.
 * @property managedDiskCustomerKeyUri Key uri to use for encryption of managed disks. Ensure the system assigned identity of the cluster has been assigned appropriate permissions(key get/wrap/unwrap permissions) on the key.
 * @property nodeCount The number of nodes the data center should have. This is the desired number. After it is set, it may take some time for the data center to be scaled to match. To monitor the number of nodes and their status, use the fetchNodeStatus method on the cluster.
 * @property provisionError Error related to resource provisioning.
 * @property provisioningState The status of the resource at the time the operation was called.
 * @property sku Virtual Machine SKU used for data centers. Default value is Standard_DS14_v2
 */
public data class DataCenterResourcePropertiesArgs(
    public val authenticationMethodLdapProperties: Output<AuthenticationMethodLdapPropertiesArgs>? =
        null,
    public val availabilityZone: Output<Boolean>? = null,
    public val backupStorageCustomerKeyUri: Output<String>? = null,
    public val base64EncodedCassandraYamlFragment: Output<String>? = null,
    public val dataCenterLocation: Output<String>? = null,
    public val deallocated: Output<Boolean>? = null,
    public val delegatedSubnetId: Output<String>? = null,
    public val diskCapacity: Output<Int>? = null,
    public val diskSku: Output<String>? = null,
    public val managedDiskCustomerKeyUri: Output<String>? = null,
    public val nodeCount: Output<Int>? = null,
    public val provisionError: Output<CassandraErrorArgs>? = null,
    public val provisioningState: Output<Either<String, ManagedCassandraProvisioningState>>? = null,
    public val sku: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.DataCenterResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.DataCenterResourcePropertiesArgs =
        com.pulumi.azurenative.documentdb.inputs.DataCenterResourcePropertiesArgs.builder()
            .authenticationMethodLdapProperties(
                authenticationMethodLdapProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .backupStorageCustomerKeyUri(backupStorageCustomerKeyUri?.applyValue({ args0 -> args0 }))
            .base64EncodedCassandraYamlFragment(
                base64EncodedCassandraYamlFragment?.applyValue({ args0 ->
                    args0
                }),
            )
            .dataCenterLocation(dataCenterLocation?.applyValue({ args0 -> args0 }))
            .deallocated(deallocated?.applyValue({ args0 -> args0 }))
            .delegatedSubnetId(delegatedSubnetId?.applyValue({ args0 -> args0 }))
            .diskCapacity(diskCapacity?.applyValue({ args0 -> args0 }))
            .diskSku(diskSku?.applyValue({ args0 -> args0 }))
            .managedDiskCustomerKeyUri(managedDiskCustomerKeyUri?.applyValue({ args0 -> args0 }))
            .nodeCount(nodeCount?.applyValue({ args0 -> args0 }))
            .provisionError(provisionError?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataCenterResourcePropertiesArgs].
 */
@PulumiTagMarker
public class DataCenterResourcePropertiesArgsBuilder internal constructor() {
    private var authenticationMethodLdapProperties: Output<AuthenticationMethodLdapPropertiesArgs>? =
        null

    private var availabilityZone: Output<Boolean>? = null

    private var backupStorageCustomerKeyUri: Output<String>? = null

    private var base64EncodedCassandraYamlFragment: Output<String>? = null

    private var dataCenterLocation: Output<String>? = null

    private var deallocated: Output<Boolean>? = null

    private var delegatedSubnetId: Output<String>? = null

    private var diskCapacity: Output<Int>? = null

    private var diskSku: Output<String>? = null

    private var managedDiskCustomerKeyUri: Output<String>? = null

    private var nodeCount: Output<Int>? = null

    private var provisionError: Output<CassandraErrorArgs>? = null

    private var provisioningState: Output<Either<String, ManagedCassandraProvisioningState>>? = null

    private var sku: Output<String>? = null

    /**
     * @param value Ldap authentication method properties. This feature is in preview.
     */
    @JvmName("exuxwifdprxtertr")
    public suspend
    fun authenticationMethodLdapProperties(`value`: Output<AuthenticationMethodLdapPropertiesArgs>) {
        this.authenticationMethodLdapProperties = value
    }

    /**
     * @param value If the data center has Availability Zone support, apply it to the Virtual Machine ScaleSet that host the cassandra data center virtual machines.
     */
    @JvmName("yadafydypkwrcucx")
    public suspend fun availabilityZone(`value`: Output<Boolean>) {
        this.availabilityZone = value
    }

    /**
     * @param value Indicates the Key Uri of the customer key to use for encryption of the backup storage account.
     */
    @JvmName("dppyqfwyshifftna")
    public suspend fun backupStorageCustomerKeyUri(`value`: Output<String>) {
        this.backupStorageCustomerKeyUri = value
    }

    /**
     * @param value A fragment of a cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this data center. The fragment should be Base64 encoded, and only a subset of keys are allowed.
     */
    @JvmName("elcaikaahgkmfpnr")
    public suspend fun base64EncodedCassandraYamlFragment(`value`: Output<String>) {
        this.base64EncodedCassandraYamlFragment = value
    }

    /**
     * @param value The region this data center should be created in.
     */
    @JvmName("mtmvbldvigmdpvmq")
    public suspend fun dataCenterLocation(`value`: Output<String>) {
        this.dataCenterLocation = value
    }

    /**
     * @param value Whether the data center has been deallocated.
     */
    @JvmName("ktxqloutsatyhajw")
    public suspend fun deallocated(`value`: Output<Boolean>) {
        this.deallocated = value
    }

    /**
     * @param value Resource id of a subnet the nodes in this data center should have their network interfaces connected to. The subnet must be in the same region specified in 'dataCenterLocation' and must be able to route to the subnet specified in the cluster's 'delegatedManagementSubnetId' property. This resource id will be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'.
     */
    @JvmName("hhceaqqqdknmgtvp")
    public suspend fun delegatedSubnetId(`value`: Output<String>) {
        this.delegatedSubnetId = value
    }

    /**
     * @param value Number of disks attached to each node. Default is 4.
     */
    @JvmName("xstnyqtgfptqvjnm")
    public suspend fun diskCapacity(`value`: Output<Int>) {
        this.diskCapacity = value
    }

    /**
     * @param value Disk SKU used for data centers. Default value is P30.
     */
    @JvmName("nxhweshfabxotsbu")
    public suspend fun diskSku(`value`: Output<String>) {
        this.diskSku = value
    }

    /**
     * @param value Key uri to use for encryption of managed disks. Ensure the system assigned identity of the cluster has been assigned appropriate permissions(key get/wrap/unwrap permissions) on the key.
     */
    @JvmName("qxcdvwbwfiayvsmw")
    public suspend fun managedDiskCustomerKeyUri(`value`: Output<String>) {
        this.managedDiskCustomerKeyUri = value
    }

    /**
     * @param value The number of nodes the data center should have. This is the desired number. After it is set, it may take some time for the data center to be scaled to match. To monitor the number of nodes and their status, use the fetchNodeStatus method on the cluster.
     */
    @JvmName("yekcrbepjatesaow")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value Error related to resource provisioning.
     */
    @JvmName("gaseunggneplotkc")
    public suspend fun provisionError(`value`: Output<CassandraErrorArgs>) {
        this.provisionError = value
    }

    /**
     * @param value The status of the resource at the time the operation was called.
     */
    @JvmName("jcuvrhuqfihpwlwf")
    public suspend
    fun provisioningState(`value`: Output<Either<String, ManagedCassandraProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Virtual Machine SKU used for data centers. Default value is Standard_DS14_v2
     */
    @JvmName("kpdtddwwitapakyl")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value Ldap authentication method properties. This feature is in preview.
     */
    @JvmName("vdryqbflonxxgmdd")
    public suspend
    fun authenticationMethodLdapProperties(`value`: AuthenticationMethodLdapPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMethodLdapProperties = mapped
    }

    /**
     * @param argument Ldap authentication method properties. This feature is in preview.
     */
    @JvmName("doomawcrnkvbgwrg")
    public suspend
    fun authenticationMethodLdapProperties(argument: suspend AuthenticationMethodLdapPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AuthenticationMethodLdapPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authenticationMethodLdapProperties = mapped
    }

    /**
     * @param value If the data center has Availability Zone support, apply it to the Virtual Machine ScaleSet that host the cassandra data center virtual machines.
     */
    @JvmName("wmwciakgrasmchih")
    public suspend fun availabilityZone(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Indicates the Key Uri of the customer key to use for encryption of the backup storage account.
     */
    @JvmName("drwhhnbqhgqeheoi")
    public suspend fun backupStorageCustomerKeyUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupStorageCustomerKeyUri = mapped
    }

    /**
     * @param value A fragment of a cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this data center. The fragment should be Base64 encoded, and only a subset of keys are allowed.
     */
    @JvmName("olnatvfshmaxyhwc")
    public suspend fun base64EncodedCassandraYamlFragment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.base64EncodedCassandraYamlFragment = mapped
    }

    /**
     * @param value The region this data center should be created in.
     */
    @JvmName("vocamjdopwbqlalv")
    public suspend fun dataCenterLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCenterLocation = mapped
    }

    /**
     * @param value Whether the data center has been deallocated.
     */
    @JvmName("vdfwbqwwsbdicnmb")
    public suspend fun deallocated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deallocated = mapped
    }

    /**
     * @param value Resource id of a subnet the nodes in this data center should have their network interfaces connected to. The subnet must be in the same region specified in 'dataCenterLocation' and must be able to route to the subnet specified in the cluster's 'delegatedManagementSubnetId' property. This resource id will be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'.
     */
    @JvmName("rptppqdbbjlhviex")
    public suspend fun delegatedSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegatedSubnetId = mapped
    }

    /**
     * @param value Number of disks attached to each node. Default is 4.
     */
    @JvmName("ijlbxxsuiosjxuji")
    public suspend fun diskCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCapacity = mapped
    }

    /**
     * @param value Disk SKU used for data centers. Default value is P30.
     */
    @JvmName("rookntktagplkarr")
    public suspend fun diskSku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSku = mapped
    }

    /**
     * @param value Key uri to use for encryption of managed disks. Ensure the system assigned identity of the cluster has been assigned appropriate permissions(key get/wrap/unwrap permissions) on the key.
     */
    @JvmName("veanywvmeqrlxpod")
    public suspend fun managedDiskCustomerKeyUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedDiskCustomerKeyUri = mapped
    }

    /**
     * @param value The number of nodes the data center should have. This is the desired number. After it is set, it may take some time for the data center to be scaled to match. To monitor the number of nodes and their status, use the fetchNodeStatus method on the cluster.
     */
    @JvmName("uyqudqfdmjbadngv")
    public suspend fun nodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value Error related to resource provisioning.
     */
    @JvmName("neteotcbvwmojolc")
    public suspend fun provisionError(`value`: CassandraErrorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionError = mapped
    }

    /**
     * @param argument Error related to resource provisioning.
     */
    @JvmName("tppvkrtxetggsirn")
    public suspend fun provisionError(argument: suspend CassandraErrorArgsBuilder.() -> Unit) {
        val toBeMapped = CassandraErrorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.provisionError = mapped
    }

    /**
     * @param value The status of the resource at the time the operation was called.
     */
    @JvmName("nehqmmodedinship")
    public suspend
    fun provisioningState(`value`: Either<String, ManagedCassandraProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the resource at the time the operation was called.
     */
    @JvmName("yhkcubiihcaepepa")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedCassandraProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the resource at the time the operation was called.
     */
    @JvmName("iixitsnekwfsmnmw")
    public fun provisioningState(`value`: ManagedCassandraProvisioningState) {
        val toBeMapped = Either.ofRight<String, ManagedCassandraProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Virtual Machine SKU used for data centers. Default value is Standard_DS14_v2
     */
    @JvmName("fuqgfdqqrcvvjthu")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    internal fun build(): DataCenterResourcePropertiesArgs = DataCenterResourcePropertiesArgs(
        authenticationMethodLdapProperties = authenticationMethodLdapProperties,
        availabilityZone = availabilityZone,
        backupStorageCustomerKeyUri = backupStorageCustomerKeyUri,
        base64EncodedCassandraYamlFragment = base64EncodedCassandraYamlFragment,
        dataCenterLocation = dataCenterLocation,
        deallocated = deallocated,
        delegatedSubnetId = delegatedSubnetId,
        diskCapacity = diskCapacity,
        diskSku = diskSku,
        managedDiskCustomerKeyUri = managedDiskCustomerKeyUri,
        nodeCount = nodeCount,
        provisionError = provisionError,
        provisioningState = provisioningState,
        sku = sku,
    )
}
