@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoDBCollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property collectionName Cosmos DB collection name.
 * @property databaseName Cosmos DB database name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMongoDBResourceMongoDBCollectionPlainArgs(
    public val accountName: String,
    public val collectionName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoDBCollectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoDBCollectionPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetMongoDBResourceMongoDBCollectionPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .collectionName(collectionName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMongoDBResourceMongoDBCollectionPlainArgs].
 */
@PulumiTagMarker
public class GetMongoDBResourceMongoDBCollectionPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var collectionName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("fqjaypfwednpysyp")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB collection name.
     */
    @JvmName("ppyljfimrsvxbgoo")
    public suspend fun collectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.collectionName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("goabqxcufycvgtxt")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wsstxtjcnowjqhbb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMongoDBResourceMongoDBCollectionPlainArgs =
        GetMongoDBResourceMongoDBCollectionPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            collectionName = collectionName ?: throw PulumiNullFieldException("collectionName"),
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
