@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlTriggerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property containerName Cosmos DB container name.
 * @property databaseName Cosmos DB database name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property triggerName Cosmos DB trigger name.
 */
public data class GetSqlResourceSqlTriggerPlainArgs(
    public val accountName: String,
    public val containerName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
    public val triggerName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlTriggerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlTriggerPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetSqlResourceSqlTriggerPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .containerName(containerName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .triggerName(triggerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlResourceSqlTriggerPlainArgs].
 */
@PulumiTagMarker
public class GetSqlResourceSqlTriggerPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var containerName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var triggerName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("tldhslnyxyibscrs")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("ujlasyfxcwjattcq")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("umiujjpkdbvnjfbd")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kewvpfxbsugvpeyd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cosmos DB trigger name.
     */
    @JvmName("kfbyxijyfxfqdjfn")
    public suspend fun triggerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.triggerName = mapped
    }

    internal fun build(): GetSqlResourceSqlTriggerPlainArgs = GetSqlResourceSqlTriggerPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        triggerName = triggerName ?: throw PulumiNullFieldException("triggerName"),
    )
}
