@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetThroughputPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property throughputPoolName Cosmos DB Throughput Pool name.
 */
public data class GetThroughputPoolPlainArgs(
    public val resourceGroupName: String,
    public val throughputPoolName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetThroughputPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetThroughputPoolPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetThroughputPoolPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .throughputPoolName(throughputPoolName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetThroughputPoolPlainArgs].
 */
@PulumiTagMarker
public class GetThroughputPoolPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var throughputPoolName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dpitwotopgrlvpcp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cosmos DB Throughput Pool name.
     */
    @JvmName("wuujiqjgimicydnp")
    public suspend fun throughputPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.throughputPoolName = mapped
    }

    internal fun build(): GetThroughputPoolPlainArgs = GetThroughputPoolPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        throughputPoolName = throughputPoolName ?: throw PulumiNullFieldException("throughputPoolName"),
    )
}
