@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.IndexesArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.DataType
import com.pulumi.azurenative.documentdb.kotlin.enums.IndexKind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The indexes for the path.
 * @property dataType The datatype for which the indexing behavior is applied to.
 * @property kind Indicates the type of index.
 * @property precision The precision of the index. -1 is maximum precision.
 */
public data class IndexesArgs(
    public val dataType: Output<Either<String, DataType>>? = null,
    public val kind: Output<Either<String, IndexKind>>? = null,
    public val precision: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.IndexesArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.IndexesArgs =
        com.pulumi.azurenative.documentdb.inputs.IndexesArgs.builder()
            .dataType(
                dataType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .precision(precision?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndexesArgs].
 */
@PulumiTagMarker
public class IndexesArgsBuilder internal constructor() {
    private var dataType: Output<Either<String, DataType>>? = null

    private var kind: Output<Either<String, IndexKind>>? = null

    private var precision: Output<Int>? = null

    /**
     * @param value The datatype for which the indexing behavior is applied to.
     */
    @JvmName("ridrwgpkxlhjoakn")
    public suspend fun dataType(`value`: Output<Either<String, DataType>>) {
        this.dataType = value
    }

    /**
     * @param value Indicates the type of index.
     */
    @JvmName("vcfitqsemkrrleyy")
    public suspend fun kind(`value`: Output<Either<String, IndexKind>>) {
        this.kind = value
    }

    /**
     * @param value The precision of the index. -1 is maximum precision.
     */
    @JvmName("nxdnrmximixdhgik")
    public suspend fun precision(`value`: Output<Int>) {
        this.precision = value
    }

    /**
     * @param value The datatype for which the indexing behavior is applied to.
     */
    @JvmName("etejaafcmgpnxqrj")
    public suspend fun dataType(`value`: Either<String, DataType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value The datatype for which the indexing behavior is applied to.
     */
    @JvmName("ohxrahapoxkqesup")
    public fun dataType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value The datatype for which the indexing behavior is applied to.
     */
    @JvmName("qqgppyxxpkdfaiho")
    public fun dataType(`value`: DataType) {
        val toBeMapped = Either.ofRight<String, DataType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataType = mapped
    }

    /**
     * @param value Indicates the type of index.
     */
    @JvmName("cheusijtvgpeopbs")
    public suspend fun kind(`value`: Either<String, IndexKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Indicates the type of index.
     */
    @JvmName("nfgeoppvcogelpmd")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IndexKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Indicates the type of index.
     */
    @JvmName("gldaivifwxmauvlm")
    public fun kind(`value`: IndexKind) {
        val toBeMapped = Either.ofRight<String, IndexKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The precision of the index. -1 is maximum precision.
     */
    @JvmName("dfyfjscngjwchqnp")
    public suspend fun precision(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.precision = mapped
    }

    internal fun build(): IndexesArgs = IndexesArgs(
        dataType = dataType,
        kind = kind,
        precision = precision,
    )
}
