@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.MongoDBCollectionResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cosmos DB MongoDB collection resource object
 * @property analyticalStorageTtl Analytical TTL.
 * @property id Name of the Cosmos DB MongoDB collection
 * @property indexes List of index keys
 * @property shardKey A key-value pair of shard keys to be applied for the request.
 */
public data class MongoDBCollectionResourceArgs(
    public val analyticalStorageTtl: Output<Int>? = null,
    public val id: Output<String>,
    public val indexes: Output<List<MongoIndexArgs>>? = null,
    public val shardKey: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.MongoDBCollectionResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.MongoDBCollectionResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.MongoDBCollectionResourceArgs.builder()
            .analyticalStorageTtl(analyticalStorageTtl?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .indexes(
                indexes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .shardKey(
                shardKey?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MongoDBCollectionResourceArgs].
 */
@PulumiTagMarker
public class MongoDBCollectionResourceArgsBuilder internal constructor() {
    private var analyticalStorageTtl: Output<Int>? = null

    private var id: Output<String>? = null

    private var indexes: Output<List<MongoIndexArgs>>? = null

    private var shardKey: Output<Map<String, String>>? = null

    /**
     * @param value Analytical TTL.
     */
    @JvmName("cipqikehtkswgtsp")
    public suspend fun analyticalStorageTtl(`value`: Output<Int>) {
        this.analyticalStorageTtl = value
    }

    /**
     * @param value Name of the Cosmos DB MongoDB collection
     */
    @JvmName("wweoiroufbwuwous")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value List of index keys
     */
    @JvmName("hpxbslcfagrocixg")
    public suspend fun indexes(`value`: Output<List<MongoIndexArgs>>) {
        this.indexes = value
    }

    @JvmName("touswyuykngfhoyx")
    public suspend fun indexes(vararg values: Output<MongoIndexArgs>) {
        this.indexes = Output.all(values.asList())
    }

    /**
     * @param values List of index keys
     */
    @JvmName("friwyglhqjtjbmsy")
    public suspend fun indexes(values: List<Output<MongoIndexArgs>>) {
        this.indexes = Output.all(values)
    }

    /**
     * @param value A key-value pair of shard keys to be applied for the request.
     */
    @JvmName("qryoeioyhuoiyaro")
    public suspend fun shardKey(`value`: Output<Map<String, String>>) {
        this.shardKey = value
    }

    /**
     * @param value Analytical TTL.
     */
    @JvmName("dckolmkvkohxavbe")
    public suspend fun analyticalStorageTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyticalStorageTtl = mapped
    }

    /**
     * @param value Name of the Cosmos DB MongoDB collection
     */
    @JvmName("pauneqbnnbgefbcg")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value List of index keys
     */
    @JvmName("qlxkwaeinywxcawd")
    public suspend fun indexes(`value`: List<MongoIndexArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexes = mapped
    }

    /**
     * @param argument List of index keys
     */
    @JvmName("klmiwssbrfcwhamr")
    public suspend fun indexes(argument: List<suspend MongoIndexArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { MongoIndexArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.indexes = mapped
    }

    /**
     * @param argument List of index keys
     */
    @JvmName("vnhuateelsmdatwm")
    public suspend fun indexes(vararg argument: suspend MongoIndexArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { MongoIndexArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.indexes = mapped
    }

    /**
     * @param argument List of index keys
     */
    @JvmName("nvdyemnifdghbctn")
    public suspend fun indexes(argument: suspend MongoIndexArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MongoIndexArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.indexes = mapped
    }

    /**
     * @param values List of index keys
     */
    @JvmName("bpjwfihihfcmpled")
    public suspend fun indexes(vararg values: MongoIndexArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.indexes = mapped
    }

    /**
     * @param value A key-value pair of shard keys to be applied for the request.
     */
    @JvmName("fdkqonfxgxjorbcj")
    public suspend fun shardKey(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardKey = mapped
    }

    /**
     * @param values A key-value pair of shard keys to be applied for the request.
     */
    @JvmName("ipbvmcxoehtgeoes")
    public fun shardKey(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shardKey = mapped
    }

    internal fun build(): MongoDBCollectionResourceArgs = MongoDBCollectionResourceArgs(
        analyticalStorageTtl = analyticalStorageTtl,
        id = id ?: throw PulumiNullFieldException("id"),
        indexes = indexes,
        shardKey = shardKey,
    )
}
