@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.MongoIndexKeysArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cosmos DB MongoDB collection resource object
 * @property keys List of keys for each MongoDB collection in the Azure Cosmos DB service
 */
public data class MongoIndexKeysArgs(
    public val keys: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.MongoIndexKeysArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.MongoIndexKeysArgs =
        com.pulumi.azurenative.documentdb.inputs.MongoIndexKeysArgs.builder()
            .keys(keys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [MongoIndexKeysArgs].
 */
@PulumiTagMarker
public class MongoIndexKeysArgsBuilder internal constructor() {
    private var keys: Output<List<String>>? = null

    /**
     * @param value List of keys for each MongoDB collection in the Azure Cosmos DB service
     */
    @JvmName("gykcqqesxygwujuj")
    public suspend fun keys(`value`: Output<List<String>>) {
        this.keys = value
    }

    @JvmName("oujemhaenhnwamws")
    public suspend fun keys(vararg values: Output<String>) {
        this.keys = Output.all(values.asList())
    }

    /**
     * @param values List of keys for each MongoDB collection in the Azure Cosmos DB service
     */
    @JvmName("fdmrpaorfvdjvota")
    public suspend fun keys(values: List<Output<String>>) {
        this.keys = Output.all(values)
    }

    /**
     * @param value List of keys for each MongoDB collection in the Azure Cosmos DB service
     */
    @JvmName("ivilwhepymkvvwhy")
    public suspend fun keys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param values List of keys for each MongoDB collection in the Azure Cosmos DB service
     */
    @JvmName("heoyxchevlylvhnv")
    public suspend fun keys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    internal fun build(): MongoIndexKeysArgs = MongoIndexKeysArgs(
        keys = keys,
    )
}
