@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.NodeGroupSpecArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.NodeKind
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specification for a node group.
 * @property diskSizeGB The disk storage size for the node group in GB. Example values: 128, 256, 512, 1024.
 * @property enableHa Whether high availability is enabled on the node group.
 * @property kind The node type deployed in the node group.
 * @property nodeCount The number of nodes in the node group.
 * @property sku The resource sku for the node group. This defines the size of CPU and memory that is provisioned for each node. Example values: 'M30', 'M40'.
 */
public data class NodeGroupSpecArgs(
    public val diskSizeGB: Output<Double>? = null,
    public val enableHa: Output<Boolean>? = null,
    public val kind: Output<Either<String, NodeKind>>? = null,
    public val nodeCount: Output<Int>? = null,
    public val sku: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.NodeGroupSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.NodeGroupSpecArgs =
        com.pulumi.azurenative.documentdb.inputs.NodeGroupSpecArgs.builder()
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .enableHa(enableHa?.applyValue({ args0 -> args0 }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .nodeCount(nodeCount?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodeGroupSpecArgs].
 */
@PulumiTagMarker
public class NodeGroupSpecArgsBuilder internal constructor() {
    private var diskSizeGB: Output<Double>? = null

    private var enableHa: Output<Boolean>? = null

    private var kind: Output<Either<String, NodeKind>>? = null

    private var nodeCount: Output<Int>? = null

    private var sku: Output<String>? = null

    /**
     * @param value The disk storage size for the node group in GB. Example values: 128, 256, 512, 1024.
     */
    @JvmName("bhednhdfcffdowsh")
    public suspend fun diskSizeGB(`value`: Output<Double>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Whether high availability is enabled on the node group.
     */
    @JvmName("dthsanswpeuhttbc")
    public suspend fun enableHa(`value`: Output<Boolean>) {
        this.enableHa = value
    }

    /**
     * @param value The node type deployed in the node group.
     */
    @JvmName("auvxglncnlhvocgt")
    public suspend fun kind(`value`: Output<Either<String, NodeKind>>) {
        this.kind = value
    }

    /**
     * @param value The number of nodes in the node group.
     */
    @JvmName("oxtvvihuqdvkbrfq")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value The resource sku for the node group. This defines the size of CPU and memory that is provisioned for each node. Example values: 'M30', 'M40'.
     */
    @JvmName("mbkghnvhtvfkhhnr")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value The disk storage size for the node group in GB. Example values: 128, 256, 512, 1024.
     */
    @JvmName("mfmsbtwypdncpycc")
    public suspend fun diskSizeGB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Whether high availability is enabled on the node group.
     */
    @JvmName("kcytxhsfmrhxolon")
    public suspend fun enableHa(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHa = mapped
    }

    /**
     * @param value The node type deployed in the node group.
     */
    @JvmName("ohwskxxyjmifuwyx")
    public suspend fun kind(`value`: Either<String, NodeKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The node type deployed in the node group.
     */
    @JvmName("kvunwotfuvmpvpvi")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NodeKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The node type deployed in the node group.
     */
    @JvmName("twqnupaamradtcnw")
    public fun kind(`value`: NodeKind) {
        val toBeMapped = Either.ofRight<String, NodeKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The number of nodes in the node group.
     */
    @JvmName("rdptvgdrnepmykcj")
    public suspend fun nodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value The resource sku for the node group. This defines the size of CPU and memory that is provisioned for each node. Example values: 'M30', 'M40'.
     */
    @JvmName("yfpqkjfomsprdftc")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    internal fun build(): NodeGroupSpecArgs = NodeGroupSpecArgs(
        diskSizeGB = diskSizeGB,
        enableHa = enableHa,
        kind = kind,
        nodeCount = nodeCount,
        sku = sku,
    )
}
