@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.RestoreParametersArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.RestoreMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Parameters to indicate the information about the restore.
 * @property databasesToRestore List of specific databases available for restore.
 * @property gremlinDatabasesToRestore List of specific gremlin databases available for restore.
 * @property restoreMode Describes the mode of the restore.
 * @property restoreSource The id of the restorable database account from which the restore has to be initiated. For example: /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
 * @property restoreTimestampInUtc Time to which the account has to be restored (ISO-8601 format).
 * @property tablesToRestore List of specific tables available for restore.
 */
public data class RestoreParametersArgs(
    public val databasesToRestore: Output<List<DatabaseRestoreResourceArgs>>? = null,
    public val gremlinDatabasesToRestore: Output<List<GremlinDatabaseRestoreResourceArgs>>? = null,
    public val restoreMode: Output<Either<String, RestoreMode>>? = null,
    public val restoreSource: Output<String>? = null,
    public val restoreTimestampInUtc: Output<String>? = null,
    public val tablesToRestore: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.RestoreParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.RestoreParametersArgs =
        com.pulumi.azurenative.documentdb.inputs.RestoreParametersArgs.builder()
            .databasesToRestore(
                databasesToRestore?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .gremlinDatabasesToRestore(
                gremlinDatabasesToRestore?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .restoreMode(
                restoreMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .restoreSource(restoreSource?.applyValue({ args0 -> args0 }))
            .restoreTimestampInUtc(restoreTimestampInUtc?.applyValue({ args0 -> args0 }))
            .tablesToRestore(tablesToRestore?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RestoreParametersArgs].
 */
@PulumiTagMarker
public class RestoreParametersArgsBuilder internal constructor() {
    private var databasesToRestore: Output<List<DatabaseRestoreResourceArgs>>? = null

    private var gremlinDatabasesToRestore: Output<List<GremlinDatabaseRestoreResourceArgs>>? = null

    private var restoreMode: Output<Either<String, RestoreMode>>? = null

    private var restoreSource: Output<String>? = null

    private var restoreTimestampInUtc: Output<String>? = null

    private var tablesToRestore: Output<List<String>>? = null

    /**
     * @param value List of specific databases available for restore.
     */
    @JvmName("wbrvijdmuqvlobxp")
    public suspend fun databasesToRestore(`value`: Output<List<DatabaseRestoreResourceArgs>>) {
        this.databasesToRestore = value
    }

    @JvmName("ykcynsxewyrnjriq")
    public suspend fun databasesToRestore(vararg values: Output<DatabaseRestoreResourceArgs>) {
        this.databasesToRestore = Output.all(values.asList())
    }

    /**
     * @param values List of specific databases available for restore.
     */
    @JvmName("eehfdidjoquonooj")
    public suspend fun databasesToRestore(values: List<Output<DatabaseRestoreResourceArgs>>) {
        this.databasesToRestore = Output.all(values)
    }

    /**
     * @param value List of specific gremlin databases available for restore.
     */
    @JvmName("vegniyosrlsikfxr")
    public suspend
    fun gremlinDatabasesToRestore(`value`: Output<List<GremlinDatabaseRestoreResourceArgs>>) {
        this.gremlinDatabasesToRestore = value
    }

    @JvmName("ymelsrklayubfsat")
    public suspend fun gremlinDatabasesToRestore(
        vararg
        values: Output<GremlinDatabaseRestoreResourceArgs>,
    ) {
        this.gremlinDatabasesToRestore = Output.all(values.asList())
    }

    /**
     * @param values List of specific gremlin databases available for restore.
     */
    @JvmName("amdvmhhqfxqlyhee")
    public suspend
    fun gremlinDatabasesToRestore(values: List<Output<GremlinDatabaseRestoreResourceArgs>>) {
        this.gremlinDatabasesToRestore = Output.all(values)
    }

    /**
     * @param value Describes the mode of the restore.
     */
    @JvmName("dstqfltxrjyfetks")
    public suspend fun restoreMode(`value`: Output<Either<String, RestoreMode>>) {
        this.restoreMode = value
    }

    /**
     * @param value The id of the restorable database account from which the restore has to be initiated. For example: /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
     */
    @JvmName("mymjgwddladecoon")
    public suspend fun restoreSource(`value`: Output<String>) {
        this.restoreSource = value
    }

    /**
     * @param value Time to which the account has to be restored (ISO-8601 format).
     */
    @JvmName("fgxsttmwrmbppdkw")
    public suspend fun restoreTimestampInUtc(`value`: Output<String>) {
        this.restoreTimestampInUtc = value
    }

    /**
     * @param value List of specific tables available for restore.
     */
    @JvmName("mymdkgifprpuwpug")
    public suspend fun tablesToRestore(`value`: Output<List<String>>) {
        this.tablesToRestore = value
    }

    @JvmName("dtjklqcpjcufcmyr")
    public suspend fun tablesToRestore(vararg values: Output<String>) {
        this.tablesToRestore = Output.all(values.asList())
    }

    /**
     * @param values List of specific tables available for restore.
     */
    @JvmName("qgqfkrcadsuobgsv")
    public suspend fun tablesToRestore(values: List<Output<String>>) {
        this.tablesToRestore = Output.all(values)
    }

    /**
     * @param value List of specific databases available for restore.
     */
    @JvmName("riiuiklfgrnnerkh")
    public suspend fun databasesToRestore(`value`: List<DatabaseRestoreResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databasesToRestore = mapped
    }

    /**
     * @param argument List of specific databases available for restore.
     */
    @JvmName("avetsbscemlouyob")
    public suspend
    fun databasesToRestore(argument: List<suspend DatabaseRestoreResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DatabaseRestoreResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.databasesToRestore = mapped
    }

    /**
     * @param argument List of specific databases available for restore.
     */
    @JvmName("ohdikbdqrgwdqtic")
    public suspend fun databasesToRestore(
        vararg
        argument: suspend DatabaseRestoreResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DatabaseRestoreResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.databasesToRestore = mapped
    }

    /**
     * @param argument List of specific databases available for restore.
     */
    @JvmName("cmdakxtxkmylcoxf")
    public suspend
    fun databasesToRestore(argument: suspend DatabaseRestoreResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DatabaseRestoreResourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.databasesToRestore = mapped
    }

    /**
     * @param values List of specific databases available for restore.
     */
    @JvmName("ldxjotumpswyfepg")
    public suspend fun databasesToRestore(vararg values: DatabaseRestoreResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databasesToRestore = mapped
    }

    /**
     * @param value List of specific gremlin databases available for restore.
     */
    @JvmName("rsvioosbjmsojecb")
    public suspend fun gremlinDatabasesToRestore(`value`: List<GremlinDatabaseRestoreResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gremlinDatabasesToRestore = mapped
    }

    /**
     * @param argument List of specific gremlin databases available for restore.
     */
    @JvmName("oxrdcrgkstxvcptj")
    public suspend
    fun gremlinDatabasesToRestore(argument: List<suspend GremlinDatabaseRestoreResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GremlinDatabaseRestoreResourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.gremlinDatabasesToRestore = mapped
    }

    /**
     * @param argument List of specific gremlin databases available for restore.
     */
    @JvmName("opeieowuylrjlajv")
    public suspend fun gremlinDatabasesToRestore(
        vararg
        argument: suspend GremlinDatabaseRestoreResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GremlinDatabaseRestoreResourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.gremlinDatabasesToRestore = mapped
    }

    /**
     * @param argument List of specific gremlin databases available for restore.
     */
    @JvmName("wyxljtiuvxtfiktr")
    public suspend
    fun gremlinDatabasesToRestore(argument: suspend GremlinDatabaseRestoreResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GremlinDatabaseRestoreResourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.gremlinDatabasesToRestore = mapped
    }

    /**
     * @param values List of specific gremlin databases available for restore.
     */
    @JvmName("sppllpbardpxdlls")
    public suspend fun gremlinDatabasesToRestore(vararg values: GremlinDatabaseRestoreResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gremlinDatabasesToRestore = mapped
    }

    /**
     * @param value Describes the mode of the restore.
     */
    @JvmName("pqvhqaulgvplrgis")
    public suspend fun restoreMode(`value`: Either<String, RestoreMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreMode = mapped
    }

    /**
     * @param value Describes the mode of the restore.
     */
    @JvmName("grkisgythjqtwphl")
    public fun restoreMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RestoreMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restoreMode = mapped
    }

    /**
     * @param value Describes the mode of the restore.
     */
    @JvmName("oferjlfarylshrfa")
    public fun restoreMode(`value`: RestoreMode) {
        val toBeMapped = Either.ofRight<String, RestoreMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restoreMode = mapped
    }

    /**
     * @param value The id of the restorable database account from which the restore has to be initiated. For example: /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
     */
    @JvmName("nsggnocsjbvxkygx")
    public suspend fun restoreSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreSource = mapped
    }

    /**
     * @param value Time to which the account has to be restored (ISO-8601 format).
     */
    @JvmName("ifenbrwrolmefjae")
    public suspend fun restoreTimestampInUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreTimestampInUtc = mapped
    }

    /**
     * @param value List of specific tables available for restore.
     */
    @JvmName("grdukfntsacofgrn")
    public suspend fun tablesToRestore(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablesToRestore = mapped
    }

    /**
     * @param values List of specific tables available for restore.
     */
    @JvmName("xujnxclogcoygsrk")
    public suspend fun tablesToRestore(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tablesToRestore = mapped
    }

    internal fun build(): RestoreParametersArgs = RestoreParametersArgs(
        databasesToRestore = databasesToRestore,
        gremlinDatabasesToRestore = gremlinDatabasesToRestore,
        restoreMode = restoreMode,
        restoreSource = restoreSource,
        restoreTimestampInUtc = restoreTimestampInUtc,
        tablesToRestore = tablesToRestore,
    )
}
