@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.RoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The set of roles permitted through this Role Definition.
 * @property db The database name the role is applied.
 * @property role The role name.
 */
public data class RoleArgs(
    public val db: Output<String>? = null,
    public val role: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.RoleArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.RoleArgs =
        com.pulumi.azurenative.documentdb.inputs.RoleArgs.builder()
            .db(db?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleArgs].
 */
@PulumiTagMarker
public class RoleArgsBuilder internal constructor() {
    private var db: Output<String>? = null

    private var role: Output<String>? = null

    /**
     * @param value The database name the role is applied.
     */
    @JvmName("frpeggldcolliwyx")
    public suspend fun db(`value`: Output<String>) {
        this.db = value
    }

    /**
     * @param value The role name.
     */
    @JvmName("pyhpbkmwhnmffbgq")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The database name the role is applied.
     */
    @JvmName("iawyfcgremcomvvu")
    public suspend fun db(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.db = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("erghmkkcilqvofqq")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    internal fun build(): RoleArgs = RoleArgs(
        db = db,
        role = role,
    )
}
