@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.SqlContainerResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Cosmos DB SQL container resource object
 * @property analyticalStorageTtl Analytical TTL.
 * @property clientEncryptionPolicy The client encryption policy for the container.
 * @property conflictResolutionPolicy The conflict resolution policy for the container.
 * @property defaultTtl Default time to live
 * @property id Name of the Cosmos DB SQL container
 * @property indexingPolicy The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
 * @property partitionKey The configuration of the partition key to be used for partitioning data into multiple partitions
 * @property uniqueKeyPolicy The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
 */
public data class SqlContainerResourceArgs(
    public val analyticalStorageTtl: Output<Double>? = null,
    public val clientEncryptionPolicy: Output<ClientEncryptionPolicyArgs>? = null,
    public val conflictResolutionPolicy: Output<ConflictResolutionPolicyArgs>? = null,
    public val defaultTtl: Output<Int>? = null,
    public val id: Output<String>,
    public val indexingPolicy: Output<IndexingPolicyArgs>? = null,
    public val partitionKey: Output<ContainerPartitionKeyArgs>? = null,
    public val uniqueKeyPolicy: Output<UniqueKeyPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.SqlContainerResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.SqlContainerResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.SqlContainerResourceArgs.builder()
            .analyticalStorageTtl(analyticalStorageTtl?.applyValue({ args0 -> args0 }))
            .clientEncryptionPolicy(
                clientEncryptionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .conflictResolutionPolicy(
                conflictResolutionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultTtl(defaultTtl?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .indexingPolicy(indexingPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .partitionKey(partitionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uniqueKeyPolicy(
                uniqueKeyPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlContainerResourceArgs].
 */
@PulumiTagMarker
public class SqlContainerResourceArgsBuilder internal constructor() {
    private var analyticalStorageTtl: Output<Double>? = null

    private var clientEncryptionPolicy: Output<ClientEncryptionPolicyArgs>? = null

    private var conflictResolutionPolicy: Output<ConflictResolutionPolicyArgs>? = null

    private var defaultTtl: Output<Int>? = null

    private var id: Output<String>? = null

    private var indexingPolicy: Output<IndexingPolicyArgs>? = null

    private var partitionKey: Output<ContainerPartitionKeyArgs>? = null

    private var uniqueKeyPolicy: Output<UniqueKeyPolicyArgs>? = null

    /**
     * @param value Analytical TTL.
     */
    @JvmName("ainhetnxcksvtiet")
    public suspend fun analyticalStorageTtl(`value`: Output<Double>) {
        this.analyticalStorageTtl = value
    }

    /**
     * @param value The client encryption policy for the container.
     */
    @JvmName("gosonraopfvoxjrp")
    public suspend fun clientEncryptionPolicy(`value`: Output<ClientEncryptionPolicyArgs>) {
        this.clientEncryptionPolicy = value
    }

    /**
     * @param value The conflict resolution policy for the container.
     */
    @JvmName("ylbhditojifdsiix")
    public suspend fun conflictResolutionPolicy(`value`: Output<ConflictResolutionPolicyArgs>) {
        this.conflictResolutionPolicy = value
    }

    /**
     * @param value Default time to live
     */
    @JvmName("nmxygudxmcqnbtti")
    public suspend fun defaultTtl(`value`: Output<Int>) {
        this.defaultTtl = value
    }

    /**
     * @param value Name of the Cosmos DB SQL container
     */
    @JvmName("qqynpmuhsldvfbul")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
     */
    @JvmName("apkyahbbkrfgwetg")
    public suspend fun indexingPolicy(`value`: Output<IndexingPolicyArgs>) {
        this.indexingPolicy = value
    }

    /**
     * @param value The configuration of the partition key to be used for partitioning data into multiple partitions
     */
    @JvmName("fihwfdoythrwmtkm")
    public suspend fun partitionKey(`value`: Output<ContainerPartitionKeyArgs>) {
        this.partitionKey = value
    }

    /**
     * @param value The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
     */
    @JvmName("tooukmionqyoqvae")
    public suspend fun uniqueKeyPolicy(`value`: Output<UniqueKeyPolicyArgs>) {
        this.uniqueKeyPolicy = value
    }

    /**
     * @param value Analytical TTL.
     */
    @JvmName("rbyjmbuhxumgcpou")
    public suspend fun analyticalStorageTtl(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyticalStorageTtl = mapped
    }

    /**
     * @param value The client encryption policy for the container.
     */
    @JvmName("wqaslbmbnejmsfvc")
    public suspend fun clientEncryptionPolicy(`value`: ClientEncryptionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientEncryptionPolicy = mapped
    }

    /**
     * @param argument The client encryption policy for the container.
     */
    @JvmName("oaqsvfexfplpigyi")
    public suspend
    fun clientEncryptionPolicy(argument: suspend ClientEncryptionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ClientEncryptionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientEncryptionPolicy = mapped
    }

    /**
     * @param value The conflict resolution policy for the container.
     */
    @JvmName("obalquxyrhhjuwah")
    public suspend fun conflictResolutionPolicy(`value`: ConflictResolutionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictResolutionPolicy = mapped
    }

    /**
     * @param argument The conflict resolution policy for the container.
     */
    @JvmName("ryxkksmtmraoubtc")
    public suspend
    fun conflictResolutionPolicy(argument: suspend ConflictResolutionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ConflictResolutionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.conflictResolutionPolicy = mapped
    }

    /**
     * @param value Default time to live
     */
    @JvmName("yumiungacljgwmjb")
    public suspend fun defaultTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTtl = mapped
    }

    /**
     * @param value Name of the Cosmos DB SQL container
     */
    @JvmName("vrgnfeccrqijhmeo")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
     */
    @JvmName("bxsaxmugigvulmsc")
    public suspend fun indexingPolicy(`value`: IndexingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexingPolicy = mapped
    }

    /**
     * @param argument The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
     */
    @JvmName("qyfhxchpenfsuiqt")
    public suspend fun indexingPolicy(argument: suspend IndexingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = IndexingPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.indexingPolicy = mapped
    }

    /**
     * @param value The configuration of the partition key to be used for partitioning data into multiple partitions
     */
    @JvmName("icfvyugnujhlfggu")
    public suspend fun partitionKey(`value`: ContainerPartitionKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKey = mapped
    }

    /**
     * @param argument The configuration of the partition key to be used for partitioning data into multiple partitions
     */
    @JvmName("njxwjllvjotggixb")
    public suspend fun partitionKey(argument: suspend ContainerPartitionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerPartitionKeyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.partitionKey = mapped
    }

    /**
     * @param value The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
     */
    @JvmName("gurtodlawocybwck")
    public suspend fun uniqueKeyPolicy(`value`: UniqueKeyPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueKeyPolicy = mapped
    }

    /**
     * @param argument The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
     */
    @JvmName("jvyqyuymerqeeoat")
    public suspend fun uniqueKeyPolicy(argument: suspend UniqueKeyPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = UniqueKeyPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.uniqueKeyPolicy = mapped
    }

    internal fun build(): SqlContainerResourceArgs = SqlContainerResourceArgs(
        analyticalStorageTtl = analyticalStorageTtl,
        clientEncryptionPolicy = clientEncryptionPolicy,
        conflictResolutionPolicy = conflictResolutionPolicy,
        defaultTtl = defaultTtl,
        id = id ?: throw PulumiNullFieldException("id"),
        indexingPolicy = indexingPolicy,
        partitionKey = partitionKey,
        uniqueKeyPolicy = uniqueKeyPolicy,
    )
}
