@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.UniqueKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The unique key on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
 * @property paths List of paths must be unique for each document in the Azure Cosmos DB service
 */
public data class UniqueKeyArgs(
    public val paths: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.UniqueKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.UniqueKeyArgs =
        com.pulumi.azurenative.documentdb.inputs.UniqueKeyArgs.builder()
            .paths(paths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [UniqueKeyArgs].
 */
@PulumiTagMarker
public class UniqueKeyArgsBuilder internal constructor() {
    private var paths: Output<List<String>>? = null

    /**
     * @param value List of paths must be unique for each document in the Azure Cosmos DB service
     */
    @JvmName("fffssvuhmlujtdij")
    public suspend fun paths(`value`: Output<List<String>>) {
        this.paths = value
    }

    @JvmName("lovdykvdhmjqrpbi")
    public suspend fun paths(vararg values: Output<String>) {
        this.paths = Output.all(values.asList())
    }

    /**
     * @param values List of paths must be unique for each document in the Azure Cosmos DB service
     */
    @JvmName("aoguexnyxqohbpdr")
    public suspend fun paths(values: List<Output<String>>) {
        this.paths = Output.all(values)
    }

    /**
     * @param value List of paths must be unique for each document in the Azure Cosmos DB service
     */
    @JvmName("pvkwtuuvaecuafuy")
    public suspend fun paths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    /**
     * @param values List of paths must be unique for each document in the Azure Cosmos DB service
     */
    @JvmName("lchejmgqlttpgakb")
    public suspend fun paths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    internal fun build(): UniqueKeyArgs = UniqueKeyArgs(
        paths = paths,
    )
}
