@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.UniqueKeyPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
 * @property uniqueKeys List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
 */
public data class UniqueKeyPolicyArgs(
    public val uniqueKeys: Output<List<UniqueKeyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.UniqueKeyPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.UniqueKeyPolicyArgs =
        com.pulumi.azurenative.documentdb.inputs.UniqueKeyPolicyArgs.builder()
            .uniqueKeys(
                uniqueKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [UniqueKeyPolicyArgs].
 */
@PulumiTagMarker
public class UniqueKeyPolicyArgsBuilder internal constructor() {
    private var uniqueKeys: Output<List<UniqueKeyArgs>>? = null

    /**
     * @param value List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
     */
    @JvmName("rctlmwugcawcnslr")
    public suspend fun uniqueKeys(`value`: Output<List<UniqueKeyArgs>>) {
        this.uniqueKeys = value
    }

    @JvmName("wjtyjrraurpcsvfa")
    public suspend fun uniqueKeys(vararg values: Output<UniqueKeyArgs>) {
        this.uniqueKeys = Output.all(values.asList())
    }

    /**
     * @param values List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
     */
    @JvmName("jiiighonvdqdktsq")
    public suspend fun uniqueKeys(values: List<Output<UniqueKeyArgs>>) {
        this.uniqueKeys = Output.all(values)
    }

    /**
     * @param value List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
     */
    @JvmName("tbddjllgtaonptgt")
    public suspend fun uniqueKeys(`value`: List<UniqueKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueKeys = mapped
    }

    /**
     * @param argument List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
     */
    @JvmName("bhfopohgfdtbnryw")
    public suspend fun uniqueKeys(argument: List<suspend UniqueKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { UniqueKeyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.uniqueKeys = mapped
    }

    /**
     * @param argument List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
     */
    @JvmName("wihglnkhmqqurexm")
    public suspend fun uniqueKeys(vararg argument: suspend UniqueKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { UniqueKeyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.uniqueKeys = mapped
    }

    /**
     * @param argument List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
     */
    @JvmName("jcschdsfaedwtcbu")
    public suspend fun uniqueKeys(argument: suspend UniqueKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UniqueKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.uniqueKeys = mapped
    }

    /**
     * @param values List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
     */
    @JvmName("kpccqopweihvanua")
    public suspend fun uniqueKeys(vararg values: UniqueKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uniqueKeys = mapped
    }

    internal fun build(): UniqueKeyPolicyArgs = UniqueKeyPolicyArgs(
        uniqueKeys = uniqueKeys,
    )
}
