@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.VirtualNetworkRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Network ACL Rule object
 * @property id Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
 * @property ignoreMissingVNetServiceEndpoint Create firewall rule before the virtual network has vnet service endpoint enabled.
 */
public data class VirtualNetworkRuleArgs(
    public val id: Output<String>? = null,
    public val ignoreMissingVNetServiceEndpoint: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.VirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.VirtualNetworkRuleArgs =
        com.pulumi.azurenative.documentdb.inputs.VirtualNetworkRuleArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .ignoreMissingVNetServiceEndpoint(
                ignoreMissingVNetServiceEndpoint?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class VirtualNetworkRuleArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var ignoreMissingVNetServiceEndpoint: Output<Boolean>? = null

    /**
     * @param value Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     */
    @JvmName("mjaktunbwfyupuuw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Create firewall rule before the virtual network has vnet service endpoint enabled.
     */
    @JvmName("sjyhywnrbpicpgkl")
    public suspend fun ignoreMissingVNetServiceEndpoint(`value`: Output<Boolean>) {
        this.ignoreMissingVNetServiceEndpoint = value
    }

    /**
     * @param value Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     */
    @JvmName("hwsydwutkftpdwta")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Create firewall rule before the virtual network has vnet service endpoint enabled.
     */
    @JvmName("csrrfsejgpqqdlle")
    public suspend fun ignoreMissingVNetServiceEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreMissingVNetServiceEndpoint = mapped
    }

    internal fun build(): VirtualNetworkRuleArgs = VirtualNetworkRuleArgs(
        id = id,
        ignoreMissingVNetServiceEndpoint = ignoreMissingVNetServiceEndpoint,
    )
}
