@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The metadata related to an access key for a given database account.
 * @property generationTime Generation time in UTC of the key in ISO-8601 format. If the value is missing from the object, it means that the last key regeneration was triggered before 2022-06-18.
 */
public data class AccountKeyMetadataResponse(
    public val generationTime: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.AccountKeyMetadataResponse):
            AccountKeyMetadataResponse = AccountKeyMetadataResponse(
            generationTime = javaType.generationTime(),
        )
    }
}
