@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The CORS policy for the Cosmos DB database account.
 * @property allowedHeaders The request headers that the origin domain may specify on the CORS request.
 * @property allowedMethods The methods (HTTP request verbs) that the origin domain may use for a CORS request.
 * @property allowedOrigins The origin domains that are permitted to make a request against the service via CORS.
 * @property exposedHeaders The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
 * @property maxAgeInSeconds The maximum amount time that a browser should cache the preflight OPTIONS request.
 */
public data class CorsPolicyResponse(
    public val allowedHeaders: String? = null,
    public val allowedMethods: String? = null,
    public val allowedOrigins: String,
    public val exposedHeaders: String? = null,
    public val maxAgeInSeconds: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.CorsPolicyResponse):
            CorsPolicyResponse = CorsPolicyResponse(
            allowedHeaders = javaType.allowedHeaders().map({ args0 -> args0 }).orElse(null),
            allowedMethods = javaType.allowedMethods().map({ args0 -> args0 }).orElse(null),
            allowedOrigins = javaType.allowedOrigins(),
            exposedHeaders = javaType.exposedHeaders().map({ args0 -> args0 }).orElse(null),
            maxAgeInSeconds = javaType.maxAgeInSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
