@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An Azure Cosmos DB User Definition
 * @property customData A custom definition for the USer Definition.
 * @property databaseName The database name for which access is being granted for this User Definition.
 * @property id The unique resource identifier of the database account.
 * @property mechanisms The Mongo Auth mechanism. For now, we only support auth mechanism SCRAM-SHA-256.
 * @property name The name of the database account.
 * @property password The password for User Definition. Response does not contain user password.
 * @property roles The set of roles inherited by the User Definition.
 * @property type The type of Azure resource.
 * @property userName The user name for User Definition.
 */
public data class GetMongoDBResourceMongoUserDefinitionResult(
    public val customData: String? = null,
    public val databaseName: String? = null,
    public val id: String,
    public val mechanisms: String? = null,
    public val name: String,
    public val password: String? = null,
    public val roles: List<RoleResponse>? = null,
    public val type: String,
    public val userName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetMongoDBResourceMongoUserDefinitionResult):
            GetMongoDBResourceMongoUserDefinitionResult = GetMongoDBResourceMongoUserDefinitionResult(
            customData = javaType.customData().map({ args0 -> args0 }).orElse(null),
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            mechanisms = javaType.mechanisms().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            roles = javaType.roles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.RoleResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
