@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specific Gremlin Databases to restore.
 * @property databaseName The name of the gremlin database available for restore.
 * @property graphNames The names of the graphs available for restore.
 */
public data class GremlinDatabaseRestoreResourceResponse(
    public val databaseName: String? = null,
    public val graphNames: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GremlinDatabaseRestoreResourceResponse):
            GremlinDatabaseRestoreResourceResponse = GremlinDatabaseRestoreResourceResponse(
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
            graphNames = javaType.graphNames().map({ args0 -> args0 }),
        )
    }
}
