@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cosmos DB MongoDB collection resource object
 * @property keys List of keys for each MongoDB collection in the Azure Cosmos DB service
 */
public data class MongoIndexKeysResponse(
    public val keys: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.MongoIndexKeysResponse):
            MongoIndexKeysResponse = MongoIndexKeysResponse(
            keys = javaType.keys().map({ args0 -> args0 }),
        )
    }
}
