@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Cosmos DB MongoDB collection index options
 * @property expireAfterSeconds Expire after seconds
 * @property unique Is unique or not
 */
public data class MongoIndexOptionsResponse(
    public val expireAfterSeconds: Int? = null,
    public val unique: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.MongoIndexOptionsResponse):
            MongoIndexOptionsResponse = MongoIndexOptionsResponse(
            expireAfterSeconds = javaType.expireAfterSeconds().map({ args0 -> args0 }).orElse(null),
            unique = javaType.unique().map({ args0 -> args0 }).orElse(null),
        )
    }
}
