@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property colls A system generated property that specified the addressable path of the collections resource.
 * @property etag A system generated property representing the resource etag required for optimistic concurrency control.
 * @property id Name of the Cosmos DB SQL database
 * @property rid A system generated property. A unique identifier.
 * @property ts A system generated property that denotes the last updated timestamp of the resource.
 * @property users A system generated property that specifies the addressable path of the users resource.
 */
public data class SqlDatabaseGetPropertiesResponseResource(
    public val colls: String? = null,
    public val etag: String,
    public val id: String,
    public val rid: String,
    public val ts: Double,
    public val users: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.SqlDatabaseGetPropertiesResponseResource):
            SqlDatabaseGetPropertiesResponseResource = SqlDatabaseGetPropertiesResponseResource(
            colls = javaType.colls().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            rid = javaType.rid(),
            ts = javaType.ts(),
            users = javaType.users().map({ args0 -> args0 }).orElse(null),
        )
    }
}
