@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.inputs

import com.pulumi.azurenative.domainregistration.inputs.AddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Address information for domain registration.
 * @property address1 First line of an Address.
 * @property address2 The second line of the Address. Optional.
 * @property city The city for the address.
 * @property country The country for the address.
 * @property postalCode The postal code for the address.
 * @property state The state or province for the address.
 */
public data class AddressArgs(
    public val address1: Output<String>,
    public val address2: Output<String>? = null,
    public val city: Output<String>,
    public val country: Output<String>,
    public val postalCode: Output<String>,
    public val state: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.domainregistration.inputs.AddressArgs> {
    override fun toJava(): com.pulumi.azurenative.domainregistration.inputs.AddressArgs =
        com.pulumi.azurenative.domainregistration.inputs.AddressArgs.builder()
            .address1(address1.applyValue({ args0 -> args0 }))
            .address2(address2?.applyValue({ args0 -> args0 }))
            .city(city.applyValue({ args0 -> args0 }))
            .country(country.applyValue({ args0 -> args0 }))
            .postalCode(postalCode.applyValue({ args0 -> args0 }))
            .state(state.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddressArgs].
 */
@PulumiTagMarker
public class AddressArgsBuilder internal constructor() {
    private var address1: Output<String>? = null

    private var address2: Output<String>? = null

    private var city: Output<String>? = null

    private var country: Output<String>? = null

    private var postalCode: Output<String>? = null

    private var state: Output<String>? = null

    /**
     * @param value First line of an Address.
     */
    @JvmName("yesjsralspcadokm")
    public suspend fun address1(`value`: Output<String>) {
        this.address1 = value
    }

    /**
     * @param value The second line of the Address. Optional.
     */
    @JvmName("teegticqoeoumtwe")
    public suspend fun address2(`value`: Output<String>) {
        this.address2 = value
    }

    /**
     * @param value The city for the address.
     */
    @JvmName("jralcgjucfwkkrqw")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value The country for the address.
     */
    @JvmName("ltqqfkdthiyhtywa")
    public suspend fun country(`value`: Output<String>) {
        this.country = value
    }

    /**
     * @param value The postal code for the address.
     */
    @JvmName("lpxgnvnigwxsltqe")
    public suspend fun postalCode(`value`: Output<String>) {
        this.postalCode = value
    }

    /**
     * @param value The state or province for the address.
     */
    @JvmName("lfqaqkeffthfnxui")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value First line of an Address.
     */
    @JvmName("cllxlsedswrpxvgb")
    public suspend fun address1(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.address1 = mapped
    }

    /**
     * @param value The second line of the Address. Optional.
     */
    @JvmName("ynymciqkidgsccuw")
    public suspend fun address2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address2 = mapped
    }

    /**
     * @param value The city for the address.
     */
    @JvmName("pxwowholvyvblxij")
    public suspend fun city(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value The country for the address.
     */
    @JvmName("uospimltnwmjrkad")
    public suspend fun country(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.country = mapped
    }

    /**
     * @param value The postal code for the address.
     */
    @JvmName("lojxvuecbgnimnch")
    public suspend fun postalCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.postalCode = mapped
    }

    /**
     * @param value The state or province for the address.
     */
    @JvmName("xeblioehrciifxej")
    public suspend fun state(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): AddressArgs = AddressArgs(
        address1 = address1 ?: throw PulumiNullFieldException("address1"),
        address2 = address2,
        city = city ?: throw PulumiNullFieldException("city"),
        country = country ?: throw PulumiNullFieldException("country"),
        postalCode = postalCode ?: throw PulumiNullFieldException("postalCode"),
        state = state ?: throw PulumiNullFieldException("state"),
    )
}
