@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.inputs

import com.pulumi.azurenative.domainregistration.inputs.GetDomainOwnershipIdentifierPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName Name of domain.
 * @property name Name of identifier.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetDomainOwnershipIdentifierPlainArgs(
    public val domainName: String,
    public val name: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.domainregistration.inputs.GetDomainOwnershipIdentifierPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.domainregistration.inputs.GetDomainOwnershipIdentifierPlainArgs =
        com.pulumi.azurenative.domainregistration.inputs.GetDomainOwnershipIdentifierPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainOwnershipIdentifierPlainArgs].
 */
@PulumiTagMarker
public class GetDomainOwnershipIdentifierPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of domain.
     */
    @JvmName("qhsxdbodrrahbroh")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Name of identifier.
     */
    @JvmName("eivqbvkuxnwqlksi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("wjskgespolvwqmph")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDomainOwnershipIdentifierPlainArgs =
        GetDomainOwnershipIdentifierPlainArgs(
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
