@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.inputs

import com.pulumi.azurenative.domainregistration.inputs.GetDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName Name of the domain.
 * @property resourceGroupName Name of the resource group to which the resource belongs.
 */
public data class GetDomainPlainArgs(
    public val domainName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.domainregistration.inputs.GetDomainPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.domainregistration.inputs.GetDomainPlainArgs =
        com.pulumi.azurenative.domainregistration.inputs.GetDomainPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainPlainArgs].
 */
@PulumiTagMarker
public class GetDomainPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the domain.
     */
    @JvmName("yfcvdfpktyafsyoi")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Name of the resource group to which the resource belongs.
     */
    @JvmName("uylxullceqkysajm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDomainPlainArgs = GetDomainPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
