@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.inputs

import com.pulumi.azurenative.domainregistration.inputs.ListTopLevelDomainAgreementsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property forTransfer If <code>true</code>, then the list of agreements will include agreements for domain transfer as well; otherwise, <code>false</code>.
 * @property includePrivacy If <code>true</code>, then the list of agreements will include agreements for domain privacy as well; otherwise, <code>false</code>.
 * @property name Name of the top-level domain.
 */
public data class ListTopLevelDomainAgreementsPlainArgs(
    public val forTransfer: Boolean? = null,
    public val includePrivacy: Boolean? = null,
    public val name: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.domainregistration.inputs.ListTopLevelDomainAgreementsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.domainregistration.inputs.ListTopLevelDomainAgreementsPlainArgs =
        com.pulumi.azurenative.domainregistration.inputs.ListTopLevelDomainAgreementsPlainArgs.builder()
            .forTransfer(forTransfer?.let({ args0 -> args0 }))
            .includePrivacy(includePrivacy?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListTopLevelDomainAgreementsPlainArgs].
 */
@PulumiTagMarker
public class ListTopLevelDomainAgreementsPlainArgsBuilder internal constructor() {
    private var forTransfer: Boolean? = null

    private var includePrivacy: Boolean? = null

    private var name: String? = null

    /**
     * @param value If <code>true</code>, then the list of agreements will include agreements for domain transfer as well; otherwise, <code>false</code>.
     */
    @JvmName("ibvvdbqenbfjqjsk")
    public suspend fun forTransfer(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.forTransfer = mapped
    }

    /**
     * @param value If <code>true</code>, then the list of agreements will include agreements for domain privacy as well; otherwise, <code>false</code>.
     */
    @JvmName("ceerwgsucchxjena")
    public suspend fun includePrivacy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includePrivacy = mapped
    }

    /**
     * @param value Name of the top-level domain.
     */
    @JvmName("yeiwhocdacxuhjlc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): ListTopLevelDomainAgreementsPlainArgs =
        ListTopLevelDomainAgreementsPlainArgs(
            forTransfer = forTransfer,
            includePrivacy = includePrivacy,
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
