@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Collection of domain name identifiers.
 * @property nextLink Link to next page of resources.
 * @property value Collection of resources.
 */
public data class ListDomainRecommendationsResult(
    public val nextLink: String,
    public val `value`: List<NameIdentifierResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.domainregistration.outputs.ListDomainRecommendationsResult):
            ListDomainRecommendationsResult = ListDomainRecommendationsResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.domainregistration.kotlin.outputs.NameIdentifierResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
