@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Collection of top-level domain legal agreements.
 * @property nextLink Link to next page of resources.
 * @property value Collection of resources.
 */
public data class ListTopLevelDomainAgreementsResult(
    public val nextLink: String,
    public val `value`: List<TldLegalAgreementResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.domainregistration.outputs.ListTopLevelDomainAgreementsResult):
            ListTopLevelDomainAgreementsResult = ListTopLevelDomainAgreementsResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.domainregistration.kotlin.outputs.TldLegalAgreementResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
