@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dynamics365fraudprotection.kotlin

import com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetailsArgs.builder
import com.pulumi.azurenative.dynamics365fraudprotection.kotlin.inputs.DFPInstanceAdministratorsArgs
import com.pulumi.azurenative.dynamics365fraudprotection.kotlin.inputs.DFPInstanceAdministratorsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an instance of a DFP instance resource.
 * Azure REST API version: 2021-02-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * ## Example Usage
 * ### Create instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instanceDetails = new AzureNative.Dynamics365Fraudprotection.InstanceDetails("instanceDetails", new()
 *     {
 *         Administration = new AzureNative.Dynamics365Fraudprotection.Inputs.DFPInstanceAdministratorsArgs
 *         {
 *             Members = new[]
 *             {
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com",
 *             },
 *         },
 *         InstanceName = "azsdktest",
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         Tags =
 *         {
 *             { "testKey", "testValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dynamics365fraudprotection/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dynamics365fraudprotection.NewInstanceDetails(ctx, "instanceDetails", &dynamics365fraudprotection.InstanceDetailsArgs{
 * 			Administration: &dynamics365fraudprotection.DFPInstanceAdministratorsArgs{
 * 				Members: pulumi.StringArray{
 * 					pulumi.String("azsdktest@microsoft.com"),
 * 					pulumi.String("azsdktest2@microsoft.com"),
 * 				},
 * 			},
 * 			InstanceName:      pulumi.String("azsdktest"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestRG"),
 * 			Tags: pulumi.StringMap{
 * 				"testKey": pulumi.String("testValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetails;
 * import com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instanceDetails = new InstanceDetails("instanceDetails", InstanceDetailsArgs.builder()
 *             .administration(Map.of("members",
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com"))
 *             .instanceName("azsdktest")
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .tags(Map.of("testKey", "testValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dynamics365fraudprotection:InstanceDetails azsdktest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dynamics365FraudProtection/instances/{instanceName}
 * ```
 * @property administration A collection of DFP instance administrators
 * @property instanceName The name of the DFP instances. It must be a minimum of 3 characters, and a maximum of 63.
 * @property location Location of the DFP resource.
 * @property resourceGroupName The name of the Azure Resource group of which a given DFP instance is part. This name must be at least 1 character in length, and no more than 90.
 * @property tags Key-value pairs of additional resource provisioning properties.
 */
public data class InstanceDetailsArgs(
    public val administration: Output<DFPInstanceAdministratorsArgs>? = null,
    public val instanceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetailsArgs =
        com.pulumi.azurenative.dynamics365fraudprotection.InstanceDetailsArgs.builder()
            .administration(administration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InstanceDetailsArgs].
 */
@PulumiTagMarker
public class InstanceDetailsArgsBuilder internal constructor() {
    private var administration: Output<DFPInstanceAdministratorsArgs>? = null

    private var instanceName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A collection of DFP instance administrators
     */
    @JvmName("mkxobhmsxsfcwmvk")
    public suspend fun administration(`value`: Output<DFPInstanceAdministratorsArgs>) {
        this.administration = value
    }

    /**
     * @param value The name of the DFP instances. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("saemjsrrbkndcvfl")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value Location of the DFP resource.
     */
    @JvmName("dfibpkufemrhvbwl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Azure Resource group of which a given DFP instance is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("ykphabjajtvitxax")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("wcyfaoykbpjxbkth")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A collection of DFP instance administrators
     */
    @JvmName("cslqsdjvevkhxgbm")
    public suspend fun administration(`value`: DFPInstanceAdministratorsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administration = mapped
    }

    /**
     * @param argument A collection of DFP instance administrators
     */
    @JvmName("dkwjleurikeuobrp")
    public suspend
    fun administration(argument: suspend DFPInstanceAdministratorsArgsBuilder.() -> Unit) {
        val toBeMapped = DFPInstanceAdministratorsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administration = mapped
    }

    /**
     * @param value The name of the DFP instances. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("gglcbmiyccvoswwi")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value Location of the DFP resource.
     */
    @JvmName("ufbuurqgxucnfptr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Azure Resource group of which a given DFP instance is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("quhomklrxahyrned")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("tgmenkbmegckhkhk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("ufutqanijajjyrpn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): InstanceDetailsArgs = InstanceDetailsArgs(
        administration = administration,
        instanceName = instanceName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
