@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dynamics365fraudprotection.kotlin.inputs

import com.pulumi.azurenative.dynamics365fraudprotection.inputs.GetInstanceDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceName The name of the instance. It must be a minimum of 3 characters, and a maximum of 63.
 * @property resourceGroupName The name of the Azure Resource group of which a given DFP instance is part. This name must be at least 1 character in length, and no more than 90.
 */
public data class GetInstanceDetailsPlainArgs(
    public val instanceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.dynamics365fraudprotection.inputs.GetInstanceDetailsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.dynamics365fraudprotection.inputs.GetInstanceDetailsPlainArgs =
        com.pulumi.azurenative.dynamics365fraudprotection.inputs.GetInstanceDetailsPlainArgs.builder()
            .instanceName(instanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceDetailsPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceDetailsPlainArgsBuilder internal constructor() {
    private var instanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the instance. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("yrvqxgnkqxtmxedd")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value The name of the Azure Resource group of which a given DFP instance is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("vbavukojjjvtoamv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInstanceDetailsPlainArgs = GetInstanceDetailsPlainArgs(
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
