@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.easm.kotlin

import com.pulumi.azurenative.easm.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.easm.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LabelByWorkspace].
 */
@PulumiTagMarker
public class LabelByWorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LabelByWorkspaceArgs = LabelByWorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LabelByWorkspaceArgsBuilder.() -> Unit) {
        val builder = LabelByWorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LabelByWorkspace {
        val builtJavaResource = com.pulumi.azurenative.easm.LabelByWorkspace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LabelByWorkspace(builtJavaResource)
    }
}

/**
 * Label details
 * Azure REST API version: 2023-04-01-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * ## Example Usage
 * ### Labels
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var labelByWorkspace = new AzureNative.Easm.LabelByWorkspace("labelByWorkspace", new()
 *     {
 *         LabelName = "ThisisaLabel",
 *         ResourceGroupName = "dummyrg",
 *         WorkspaceName = "ThisisaWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/easm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := easm.NewLabelByWorkspace(ctx, "labelByWorkspace", &easm.LabelByWorkspaceArgs{
 * 			LabelName:         pulumi.String("ThisisaLabel"),
 * 			ResourceGroupName: pulumi.String("dummyrg"),
 * 			WorkspaceName:     pulumi.String("ThisisaWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.easm.LabelByWorkspace;
 * import com.pulumi.azurenative.easm.LabelByWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var labelByWorkspace = new LabelByWorkspace("labelByWorkspace", LabelByWorkspaceArgs.builder()
 *             .labelName("ThisisaLabel")
 *             .resourceGroupName("dummyrg")
 *             .workspaceName("ThisisaWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:easm:LabelByWorkspace ThisisaLabel /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Easm/workspaces/{workspaceName}/labels/{labelName}
 * ```
 */
public class LabelByWorkspace internal constructor(
    override val javaResource: com.pulumi.azurenative.easm.LabelByWorkspace,
) : KotlinCustomResource(javaResource, LabelByWorkspaceMapper) {
    /**
     * Label color.
     */
    public val color: Output<String>?
        get() = javaResource.color().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Label display name.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LabelByWorkspaceMapper : ResourceMapper<LabelByWorkspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.easm.LabelByWorkspace::class == javaResource::class

    override fun map(javaResource: Resource): LabelByWorkspace = LabelByWorkspace(
        javaResource as
            com.pulumi.azurenative.easm.LabelByWorkspace,
    )
}

/**
 * @see [LabelByWorkspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LabelByWorkspace].
 */
public suspend fun labelByWorkspace(
    name: String,
    block: suspend LabelByWorkspaceResourceBuilder.() -> Unit,
): LabelByWorkspace {
    val builder = LabelByWorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LabelByWorkspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun labelByWorkspace(name: String): LabelByWorkspace {
    val builder = LabelByWorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
