@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.CustomerSubscriptionDetails.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Holds Customer subscription details. Clients can display available products to unregistered customers by explicitly passing subscription details.
 * @property locationPlacementId Location placement Id of a subscription.
 * @property quotaId Quota ID of a subscription.
 * @property registeredFeatures List of registered feature flags for subscription.
 */
public data class CustomerSubscriptionDetails(
    public val locationPlacementId: String? = null,
    public val quotaId: String,
    public val registeredFeatures: List<CustomerSubscriptionRegisteredFeatures>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.CustomerSubscriptionDetails> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.CustomerSubscriptionDetails =
        com.pulumi.azurenative.edgeorder.inputs.CustomerSubscriptionDetails.builder()
            .locationPlacementId(locationPlacementId?.let({ args0 -> args0 }))
            .quotaId(quotaId.let({ args0 -> args0 }))
            .registeredFeatures(
                registeredFeatures?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomerSubscriptionDetails].
 */
@PulumiTagMarker
public class CustomerSubscriptionDetailsBuilder internal constructor() {
    private var locationPlacementId: String? = null

    private var quotaId: String? = null

    private var registeredFeatures: List<CustomerSubscriptionRegisteredFeatures>? = null

    /**
     * @param value Location placement Id of a subscription.
     */
    @JvmName("vvfgdumbtknkemsp")
    public suspend fun locationPlacementId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.locationPlacementId = mapped
    }

    /**
     * @param value Quota ID of a subscription.
     */
    @JvmName("xcrqhfjhebwixxfb")
    public suspend fun quotaId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.quotaId = mapped
    }

    /**
     * @param value List of registered feature flags for subscription.
     */
    @JvmName("kwutqcoevlnljhym")
    public suspend fun registeredFeatures(`value`: List<CustomerSubscriptionRegisteredFeatures>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.registeredFeatures = mapped
    }

    /**
     * @param argument List of registered feature flags for subscription.
     */
    @JvmName("rgvacsgemthjqbia")
    public suspend
    fun registeredFeatures(argument: List<suspend CustomerSubscriptionRegisteredFeaturesBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomerSubscriptionRegisteredFeaturesBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.registeredFeatures = mapped
    }

    /**
     * @param argument List of registered feature flags for subscription.
     */
    @JvmName("kyaatqmatroxglyx")
    public suspend fun registeredFeatures(
        vararg
        argument: suspend CustomerSubscriptionRegisteredFeaturesBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomerSubscriptionRegisteredFeaturesBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.registeredFeatures = mapped
    }

    /**
     * @param argument List of registered feature flags for subscription.
     */
    @JvmName("ageixxxbertvrmyf")
    public suspend
    fun registeredFeatures(argument: suspend CustomerSubscriptionRegisteredFeaturesBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomerSubscriptionRegisteredFeaturesBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.registeredFeatures = mapped
    }

    /**
     * @param values List of registered feature flags for subscription.
     */
    @JvmName("nmnwudbvcbiryiwt")
    public suspend fun registeredFeatures(vararg values: CustomerSubscriptionRegisteredFeatures) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registeredFeatures = mapped
    }

    internal fun build(): CustomerSubscriptionDetails = CustomerSubscriptionDetails(
        locationPlacementId = locationPlacementId,
        quotaId = quotaId ?: throw PulumiNullFieldException("quotaId"),
        registeredFeatures = registeredFeatures,
    )
}
