@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.GetOrderItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand $expand is supported on parent device details, device details, forward shipping details and reverse shipping details parameters. Each of these can be provided as a comma separated list. Parent Device Details for order item provides details on the devices of the product, Device Details for order item provides details on the devices of the child configurations of the product, Forward and Reverse Shipping details provide forward and reverse shipping details respectively.
 * @property orderItemName The name of the order item.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetOrderItemPlainArgs(
    public val expand: String? = null,
    public val orderItemName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.GetOrderItemPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.GetOrderItemPlainArgs =
        com.pulumi.azurenative.edgeorder.inputs.GetOrderItemPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .orderItemName(orderItemName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrderItemPlainArgs].
 */
@PulumiTagMarker
public class GetOrderItemPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var orderItemName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value $expand is supported on parent device details, device details, forward shipping details and reverse shipping details parameters. Each of these can be provided as a comma separated list. Parent Device Details for order item provides details on the devices of the product, Device Details for order item provides details on the devices of the child configurations of the product, Forward and Reverse Shipping details provide forward and reverse shipping details respectively.
     */
    @JvmName("feuixnwlddhkowfw")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the order item.
     */
    @JvmName("ltyuhtvrmydwbqtx")
    public suspend fun orderItemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.orderItemName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tgbcvomcomllxqdd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetOrderItemPlainArgs = GetOrderItemPlainArgs(
        expand = expand,
        orderItemName = orderItemName ?: throw PulumiNullFieldException("orderItemName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
