@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.ListProductsAndConfigurationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property configurationFilter Holds details about product hierarchy information and filterable property.
 * @property customerSubscriptionDetails Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details.
 * @property skipToken $skipToken is supported on list of configurations, which provides the next page in the list of configurations.
 */
public data class ListProductsAndConfigurationsPlainArgs(
    public val configurationFilter: ConfigurationFilter? = null,
    public val customerSubscriptionDetails: CustomerSubscriptionDetails? = null,
    public val skipToken: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.ListProductsAndConfigurationsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.edgeorder.inputs.ListProductsAndConfigurationsPlainArgs =
        com.pulumi.azurenative.edgeorder.inputs.ListProductsAndConfigurationsPlainArgs.builder()
            .configurationFilter(configurationFilter?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customerSubscriptionDetails(
                customerSubscriptionDetails?.let({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListProductsAndConfigurationsPlainArgs].
 */
@PulumiTagMarker
public class ListProductsAndConfigurationsPlainArgsBuilder internal constructor() {
    private var configurationFilter: ConfigurationFilter? = null

    private var customerSubscriptionDetails: CustomerSubscriptionDetails? = null

    private var skipToken: String? = null

    /**
     * @param value Holds details about product hierarchy information and filterable property.
     */
    @JvmName("ngcefcrpssayfifm")
    public suspend fun configurationFilter(`value`: ConfigurationFilter?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.configurationFilter = mapped
    }

    /**
     * @param argument Holds details about product hierarchy information and filterable property.
     */
    @JvmName("xnpvurqnalnhnjvv")
    public suspend fun configurationFilter(argument: suspend ConfigurationFilterBuilder.() -> Unit) {
        val toBeMapped = ConfigurationFilterBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.configurationFilter = mapped
    }

    /**
     * @param value Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details.
     */
    @JvmName("mimvxyptygahoskm")
    public suspend fun customerSubscriptionDetails(`value`: CustomerSubscriptionDetails?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.customerSubscriptionDetails = mapped
    }

    /**
     * @param argument Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details.
     */
    @JvmName("wvkxovsjkskfoldg")
    public suspend
    fun customerSubscriptionDetails(argument: suspend CustomerSubscriptionDetailsBuilder.() -> Unit) {
        val toBeMapped = CustomerSubscriptionDetailsBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.customerSubscriptionDetails = mapped
    }

    /**
     * @param value $skipToken is supported on list of configurations, which provides the next page in the list of configurations.
     */
    @JvmName("cmgtimwxsrbmxpxf")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListProductsAndConfigurationsPlainArgs =
        ListProductsAndConfigurationsPlainArgs(
            configurationFilter = configurationFilter,
            customerSubscriptionDetails = customerSubscriptionDetails,
            skipToken = skipToken,
        )
}
