@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.ProductDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents product details
 * @property hierarchyInformation Hierarchy of the product which uniquely identifies the product
 * @property optInAdditionalConfigurations List of additional configurations customer wants in the order item apart from the ones included in the base configuration.
 */
public data class ProductDetailsArgs(
    public val hierarchyInformation: Output<HierarchyInformationArgs>,
    public val optInAdditionalConfigurations: Output<List<AdditionalConfigurationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.ProductDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.ProductDetailsArgs =
        com.pulumi.azurenative.edgeorder.inputs.ProductDetailsArgs.builder()
            .hierarchyInformation(
                hierarchyInformation.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .optInAdditionalConfigurations(
                optInAdditionalConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ProductDetailsArgs].
 */
@PulumiTagMarker
public class ProductDetailsArgsBuilder internal constructor() {
    private var hierarchyInformation: Output<HierarchyInformationArgs>? = null

    private var optInAdditionalConfigurations: Output<List<AdditionalConfigurationArgs>>? = null

    /**
     * @param value Hierarchy of the product which uniquely identifies the product
     */
    @JvmName("pnuvloeiivfreptr")
    public suspend fun hierarchyInformation(`value`: Output<HierarchyInformationArgs>) {
        this.hierarchyInformation = value
    }

    /**
     * @param value List of additional configurations customer wants in the order item apart from the ones included in the base configuration.
     */
    @JvmName("mqhihuyjhgpawesx")
    public suspend
    fun optInAdditionalConfigurations(`value`: Output<List<AdditionalConfigurationArgs>>) {
        this.optInAdditionalConfigurations = value
    }

    @JvmName("yekjberkjhftaapl")
    public suspend fun optInAdditionalConfigurations(
        vararg
        values: Output<AdditionalConfigurationArgs>,
    ) {
        this.optInAdditionalConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of additional configurations customer wants in the order item apart from the ones included in the base configuration.
     */
    @JvmName("fuqjuewhgstfwmtd")
    public suspend
    fun optInAdditionalConfigurations(values: List<Output<AdditionalConfigurationArgs>>) {
        this.optInAdditionalConfigurations = Output.all(values)
    }

    /**
     * @param value Hierarchy of the product which uniquely identifies the product
     */
    @JvmName("xqssmjajwtxifjup")
    public suspend fun hierarchyInformation(`value`: HierarchyInformationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hierarchyInformation = mapped
    }

    /**
     * @param argument Hierarchy of the product which uniquely identifies the product
     */
    @JvmName("kewajfdlqtnflajr")
    public suspend
    fun hierarchyInformation(argument: suspend HierarchyInformationArgsBuilder.() -> Unit) {
        val toBeMapped = HierarchyInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hierarchyInformation = mapped
    }

    /**
     * @param value List of additional configurations customer wants in the order item apart from the ones included in the base configuration.
     */
    @JvmName("rlygsykifrurcifr")
    public suspend fun optInAdditionalConfigurations(`value`: List<AdditionalConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optInAdditionalConfigurations = mapped
    }

    /**
     * @param argument List of additional configurations customer wants in the order item apart from the ones included in the base configuration.
     */
    @JvmName("fqwudnvupdfpcgjx")
    public suspend
    fun optInAdditionalConfigurations(argument: List<suspend AdditionalConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AdditionalConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.optInAdditionalConfigurations = mapped
    }

    /**
     * @param argument List of additional configurations customer wants in the order item apart from the ones included in the base configuration.
     */
    @JvmName("srcycktkxequtxxk")
    public suspend fun optInAdditionalConfigurations(
        vararg
        argument: suspend AdditionalConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AdditionalConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.optInAdditionalConfigurations = mapped
    }

    /**
     * @param argument List of additional configurations customer wants in the order item apart from the ones included in the base configuration.
     */
    @JvmName("akytasbgydvncqju")
    public suspend
    fun optInAdditionalConfigurations(argument: suspend AdditionalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AdditionalConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.optInAdditionalConfigurations = mapped
    }

    /**
     * @param values List of additional configurations customer wants in the order item apart from the ones included in the base configuration.
     */
    @JvmName("fvenvoyagbcvwmvi")
    public suspend fun optInAdditionalConfigurations(vararg values: AdditionalConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optInAdditionalConfigurations = mapped
    }

    internal fun build(): ProductDetailsArgs = ProductDetailsArgs(
        hierarchyInformation = hierarchyInformation ?: throw
            PulumiNullFieldException("hierarchyInformation"),
        optInAdditionalConfigurations = optInAdditionalConfigurations,
    )
}
