@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cost information for the product system.
 * @property billingInfoUrl Default url to display billing information.
 * @property billingMeterDetails Details on the various billing aspects for the product system.
 */
public data class CostInformationResponse(
    public val billingInfoUrl: String,
    public val billingMeterDetails: List<BillingMeterDetailsResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.CostInformationResponse):
            CostInformationResponse = CostInformationResponse(
            billingInfoUrl = javaType.billingInfoUrl(),
            billingMeterDetails = javaType.billingMeterDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.BillingMeterDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
