@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Dimensions of a configuration.
 * @property depth Depth of the device.
 * @property height Height of the device.
 * @property length Length of the device.
 * @property lengthHeightUnit Unit for the dimensions of length, height and width.
 * @property weight Weight of the device.
 * @property weightUnit Unit for the dimensions of weight.
 * @property width Width of the device.
 */
public data class DimensionsResponse(
    public val depth: Double,
    public val height: Double,
    public val length: Double,
    public val lengthHeightUnit: String,
    public val weight: Double,
    public val weightUnit: String,
    public val width: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.DimensionsResponse):
            DimensionsResponse = DimensionsResponse(
            depth = javaType.depth(),
            height = javaType.height(),
            length = javaType.length(),
            lengthHeightUnit = javaType.lengthHeightUnit(),
            weight = javaType.weight(),
            weightUnit = javaType.weightUnit(),
            width = javaType.width(),
        )
    }
}
