@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Provisioning state of the monitoring tag rules.
 */
public enum class ProvisioningState(
    public val javaValue: com.pulumi.azurenative.elastic.enums.ProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.enums.ProvisioningState> {
    Accepted(com.pulumi.azurenative.elastic.enums.ProvisioningState.Accepted),
    Creating(com.pulumi.azurenative.elastic.enums.ProvisioningState.Creating),
    Updating(com.pulumi.azurenative.elastic.enums.ProvisioningState.Updating),
    Deleting(com.pulumi.azurenative.elastic.enums.ProvisioningState.Deleting),
    Succeeded(com.pulumi.azurenative.elastic.enums.ProvisioningState.Succeeded),
    Failed(com.pulumi.azurenative.elastic.enums.ProvisioningState.Failed),
    Canceled(com.pulumi.azurenative.elastic.enums.ProvisioningState.Canceled),
    Deleted(com.pulumi.azurenative.elastic.enums.ProvisioningState.Deleted),
    NotSpecified(com.pulumi.azurenative.elastic.enums.ProvisioningState.NotSpecified),
    ;

    override fun toJava(): com.pulumi.azurenative.elastic.enums.ProvisioningState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elastic.enums.ProvisioningState):
            ProvisioningState = ProvisioningState.values().first { it.javaValue == javaType }
    }
}
